/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttributeFactory;
import ch.epfl.lamp.fjbg.JClass;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class JAttribute {
    protected final int nameIdx;

    public static void writeTo(List attrs, DataOutputStream stream) throws IOException {
        stream.writeShort(attrs.size());
        for (JAttribute attr : attrs) {
            attr.writeTo(stream);
        }
    }

    public static List readFrom(FJBGContext context, JClass clazz2, Object owner, DataInputStream stream) throws IOException {
        JAttributeFactory factory = context.getJAttributeFactory();
        int count2 = stream.readShort();
        ArrayList<JAttribute> list2 = new ArrayList<JAttribute>(count2);
        for (int i = 0; i < count2; ++i) {
            list2.add(factory.newInstance(clazz2, owner, stream));
        }
        return list2;
    }

    public JAttribute(FJBGContext context, JClass clazz2) {
        this.nameIdx = clazz2.getConstantPool().addUtf8(this.getName());
    }

    public JAttribute(FJBGContext context, JClass clazz2, String name) {
        this.nameIdx = clazz2.getConstantPool().addUtf8(name);
    }

    public abstract String getName();

    public void writeTo(DataOutputStream stream) throws IOException {
        int contentsSize = this.getSize();
        stream.writeShort(this.nameIdx);
        stream.writeInt(contentsSize);
        int streamSizeBefore = stream.size();
        this.writeContentsTo(stream);
        int streamSizeDiff = stream.size() - streamSizeBefore;
        assert (contentsSize == streamSizeDiff) : "invalid size for attribute " + this.getName() + " given: " + contentsSize + " actual: " + streamSizeDiff;
    }

    protected abstract int getSize();

    protected abstract void writeContentsTo(DataOutputStream var1) throws IOException;
}

