/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.annotations.helpers;

import com.univocity.parsers.annotations.BooleanString;
import com.univocity.parsers.annotations.Convert;
import com.univocity.parsers.annotations.Format;
import com.univocity.parsers.annotations.LowerCase;
import com.univocity.parsers.annotations.NullString;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.annotations.Replace;
import com.univocity.parsers.annotations.Trim;
import com.univocity.parsers.annotations.UpperCase;
import com.univocity.parsers.conversions.Conversion;
import com.univocity.parsers.conversions.Conversions;
import com.univocity.parsers.conversions.FormattedConversion;
import com.univocity.parsers.conversions.ObjectConversion;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class AnnotationHelper {
    private AnnotationHelper() {
    }

    private static String getNullValue(String defaultValue2) {
        if (defaultValue2.equals("null")) {
            return null;
        }
        if (defaultValue2.equals("'null'")) {
            return "null";
        }
        return defaultValue2;
    }

    private static String getNullWriteValue(Parsed parsed) {
        return AnnotationHelper.getNullValue(parsed.defaultNullWrite());
    }

    private static String getNullReadValue(Parsed parsed) {
        return AnnotationHelper.getNullValue(parsed.defaultNullRead());
    }

    private static String[] addNull(String[] strings) {
        String[] out = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            if ("null".equals(strings[i])) {
                out[i] = null;
            }
            if (!"'null'".equals(strings[i])) continue;
            out[i] = "null";
        }
        return strings;
    }

    public static Conversion getConversion(Field field2, Annotation annotation2) {
        try {
            Parsed parsed = field2.getAnnotation(Parsed.class);
            Class<? extends Annotation> annType = annotation2.annotationType();
            String nullRead = AnnotationHelper.getNullReadValue(parsed);
            String nullWrite = AnnotationHelper.getNullWriteValue(parsed);
            Class<?> fieldType = field2.getType();
            if (annType == NullString.class) {
                String[] nulls = ((NullString)annotation2).nulls();
                return Conversions.toNull(nulls);
            }
            if (annType == Trim.class) {
                return Conversions.trim();
            }
            if (annType == LowerCase.class) {
                return Conversions.toLowerCase();
            }
            if (annType == UpperCase.class) {
                return Conversions.toUpperCase();
            }
            if (annType == Replace.class) {
                Replace replace = (Replace)annotation2;
                return Conversions.replace(replace.expression(), replace.replacement());
            }
            if (annType == BooleanString.class) {
                Boolean valueForNull;
                if (fieldType != Boolean.TYPE && fieldType != Boolean.class) {
                    throw new IllegalArgumentException("Invalid annotation: Field " + field2.getName() + " has type " + fieldType.getName() + " instead of boolean.");
                }
                BooleanString boolString = (BooleanString)annotation2;
                String[] falseStrings = AnnotationHelper.addNull(boolString.falseStrings());
                String[] trueStrings = AnnotationHelper.addNull(boolString.trueStrings());
                Boolean bl = valueForNull = nullRead == null ? null : Boolean.valueOf(nullRead);
                if (valueForNull == null && fieldType == Boolean.TYPE) {
                    valueForNull = Boolean.FALSE;
                }
                return Conversions.toBoolean(valueForNull, nullWrite, trueStrings, falseStrings);
            }
            if (annType == Format.class) {
                Format format2 = (Format)annotation2;
                String[] formats = format2.formats();
                ObjectConversion conversion = null;
                if (fieldType == BigDecimal.class) {
                    BigDecimal defaultForNull = nullRead == null ? null : new BigDecimal(nullRead);
                    conversion = Conversions.formatToBigDecimal(defaultForNull, nullWrite, formats);
                } else if (Number.class.isAssignableFrom(fieldType)) {
                    conversion = Conversions.formatToNumber(formats);
                } else {
                    Date dateIfNull = null;
                    if (nullRead != null) {
                        if (nullRead.equalsIgnoreCase("now")) {
                            dateIfNull = new Date();
                        } else {
                            if (formats.length == 0) {
                                throw new IllegalArgumentException("No format defined");
                            }
                            SimpleDateFormat sdf = new SimpleDateFormat(formats[0]);
                            dateIfNull = sdf.parse(nullRead);
                        }
                    }
                    if (Date.class == fieldType) {
                        conversion = Conversions.toDate(dateIfNull, nullWrite, formats);
                    } else if (Calendar.class == fieldType) {
                        Calendar calendarIfNull = null;
                        if (dateIfNull != null) {
                            calendarIfNull = Calendar.getInstance();
                            calendarIfNull.setTime(dateIfNull);
                        }
                        conversion = Conversions.toCalendar(calendarIfNull, nullWrite, formats);
                    }
                }
                if (conversion != null) {
                    Object[] options = format2.options();
                    if (options.length > 0) {
                        if (conversion instanceof FormattedConversion) {
                            T[] formatters;
                            for (Object formatter : formatters = ((FormattedConversion)((Object)conversion)).getFormatterObjects()) {
                                AnnotationHelper.applyFormatSettings(formatter, (String[])options);
                            }
                        } else {
                            throw new IllegalStateException("Options '" + Arrays.toString(options) + "' not supported by conversion of type '" + conversion.getClass() + "'. It must implement " + FormattedConversion.class);
                        }
                    }
                    return conversion;
                }
            } else if (annType == Convert.class) {
                Convert convert = (Convert)annotation2;
                String[] args2 = convert.args();
                Class<? extends Conversion> conversionClass = convert.conversionClass();
                if (!Conversion.class.isAssignableFrom(conversionClass)) {
                    throw new IllegalArgumentException("Not a valid conversion class: '" + conversionClass.getName() + "'");
                }
                Constructor<? extends Conversion> constructor = conversionClass.getConstructor(String[].class);
                return constructor.newInstance(new Object[]{args2});
            }
            return null;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static Conversion getDefaultConversion(Field field2) {
        Parsed parsed = field2.getAnnotation(Parsed.class);
        Class<?> fieldType = field2.getType();
        String nullRead = AnnotationHelper.getNullReadValue(parsed);
        Comparable<Boolean> valueIfStringIsNull = null;
        ObjectConversion conversion = null;
        if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
            conversion = Conversions.toBoolean();
            valueIfStringIsNull = nullRead == null ? null : Boolean.valueOf(nullRead);
        } else if (fieldType == Character.class || fieldType == Character.TYPE) {
            conversion = Conversions.toChar();
            if (nullRead != null && nullRead.length() > 1) {
                throw new IllegalArgumentException("Invalid default value for character '" + nullRead + "'. It should contain one character only.");
            }
            valueIfStringIsNull = nullRead == null ? null : Character.valueOf(nullRead.charAt(0));
        } else if (fieldType == Byte.class || fieldType == Byte.TYPE) {
            conversion = Conversions.toByte();
            valueIfStringIsNull = nullRead == null ? null : Byte.valueOf(nullRead);
        } else if (fieldType == Short.class || fieldType == Short.TYPE) {
            conversion = Conversions.toShort();
            valueIfStringIsNull = nullRead == null ? null : Short.valueOf(nullRead);
        } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
            conversion = Conversions.toInteger();
            valueIfStringIsNull = nullRead == null ? null : Integer.valueOf(nullRead);
        } else if (fieldType == Float.class || fieldType == Float.TYPE) {
            conversion = Conversions.toFloat();
            valueIfStringIsNull = nullRead == null ? null : Float.valueOf(nullRead);
        } else if (fieldType == Double.class || fieldType == Double.TYPE) {
            conversion = Conversions.toDouble();
            valueIfStringIsNull = nullRead == null ? null : Double.valueOf(nullRead);
        } else if (fieldType == BigInteger.class) {
            conversion = Conversions.toBigInteger();
            valueIfStringIsNull = nullRead == null ? null : new BigInteger(nullRead);
        } else if (fieldType == BigDecimal.class) {
            conversion = Conversions.toBigDecimal();
            Comparable<BigDecimal> comparable = valueIfStringIsNull = nullRead == null ? null : new BigDecimal(nullRead);
        }
        if (conversion != null) {
            conversion.setValueIfStringIsNull(valueIfStringIsNull);
            conversion.setValueIfObjectIsNull(AnnotationHelper.getNullWriteValue(parsed));
        }
        return conversion;
    }

    public static void applyFormatSettings(Object formatter, String[] propertiesAndValues) {
        if (propertiesAndValues.length == 0) {
            return;
        }
        HashMap<String, String> values2 = new HashMap<String, String>();
        for (String setting : propertiesAndValues) {
            if (setting == null) {
                throw new IllegalArgumentException("Illegal format setting '" + setting + "' among: " + Arrays.toString(propertiesAndValues));
            }
            String[] pair2 = setting.split("=");
            if (pair2.length != 2) {
                throw new IllegalArgumentException("Illegal format setting '" + setting + "' among: " + Arrays.toString(propertiesAndValues));
            }
            values2.put(pair2[0], pair2[1]);
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(formatter.getClass(), Object.class);
            for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
                String name = property.getName();
                String value2 = (String)values2.remove(name);
                if (value2 != null) {
                    AnnotationHelper.invokeSetter(formatter, property, value2);
                }
                if (!property.getName().equals("decimalFormatSymbols")) continue;
                DecimalFormatSymbols modifiedDecimalSymbols = new DecimalFormatSymbols();
                boolean modified = false;
                try {
                    BeanInfo decimalBeanInfo = Introspector.getBeanInfo(modifiedDecimalSymbols.getClass(), Object.class);
                    for (PropertyDescriptor prop : decimalBeanInfo.getPropertyDescriptors()) {
                        value2 = (String)values2.remove(prop.getName());
                        if (value2 == null) continue;
                        AnnotationHelper.invokeSetter(modifiedDecimalSymbols, prop, value2);
                        modified = true;
                    }
                    if (!modified) continue;
                    property.getWriteMethod().invoke(formatter, modifiedDecimalSymbols);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Error trying to configure decimal symbols  of formatter '" + formatter.getClass() + ".", ex);
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (!values2.isEmpty()) {
            throw new IllegalArgumentException("Cannot find properties in formatter of type '" + formatter.getClass() + "': " + values2);
        }
    }

    private static void invokeSetter(Object formatter, PropertyDescriptor property, String value2) {
        Method writeMethod = property.getWriteMethod();
        if (writeMethod == null) {
            throw new IllegalArgumentException("Cannot set property '" + property.getName() + "' of formatter '" + formatter.getClass() + "' to " + value2 + ". No setter defined");
        }
        Class<?> parameterType = writeMethod.getParameterTypes()[0];
        Object parameterValue = null;
        if (parameterType == String.class) {
            parameterValue = value2;
        } else if (parameterType == Integer.class || parameterType == Integer.TYPE) {
            parameterValue = Integer.parseInt(value2);
        } else if (parameterType == Character.class || parameterType == Character.TYPE) {
            parameterValue = Character.valueOf(value2.charAt(0));
        } else if (parameterType == Currency.class) {
            parameterValue = Currency.getInstance(value2);
        } else if (parameterType == Boolean.class) {
            parameterValue = Boolean.valueOf(value2);
        } else if (parameterType == TimeZone.class) {
            parameterValue = TimeZone.getTimeZone(value2);
        } else if (parameterType == DateFormatSymbols.class) {
            parameterValue = DateFormatSymbols.getInstance(new Locale(value2));
        }
        if (parameterValue == null) {
            throw new IllegalArgumentException("Cannot set property '" + property.getName() + "' of formatter '" + formatter.getClass() + ". Cannot convert '" + value2 + "' to instance of " + parameterType);
        }
        try {
            writeMethod.invoke(formatter, parameterValue);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error setting property '" + property.getName() + "' of formatter '" + formatter.getClass() + ", with '" + parameterValue + "' (converted from '" + value2 + "')", e);
        }
    }
}

