/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.common.DefaultParsingContext;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.LineReader;
import com.univocity.parsers.common.ParserOutput;
import com.univocity.parsers.common.TextParsingException;
import com.univocity.parsers.common.input.CharInputReader;
import com.univocity.parsers.common.input.DefaultCharInputReader;
import com.univocity.parsers.common.input.EOFException;
import com.univocity.parsers.common.processor.RowProcessor;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractParser<T extends CommonParserSettings<?>> {
    protected DefaultParsingContext context;
    private final RowProcessor processor;
    private final int recordsToRead;
    private final char comment;
    protected final T settings;
    protected CharInputReader input;
    protected final ParserOutput output;
    protected char ch;
    private final LineReader lineReader = new LineReader();

    public AbstractParser(T settings2) {
        this.settings = settings2;
        this.output = new ParserOutput((CommonParserSettings<?>)settings2);
        this.processor = ((CommonParserSettings)settings2).getRowProcessor();
        this.recordsToRead = ((CommonParserSettings)settings2).getNumberOfRecordsToRead();
        this.comment = ((Format)((CommonSettings)settings2).getFormat()).getComment();
    }

    protected abstract void parseRecord();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parse(Reader reader) {
        this.beginParsing(reader);
        try {
            while (!this.context.stopped) {
                this.ch = this.input.nextChar();
                if (this.ch == this.comment) {
                    this.input.skipLines(1);
                    continue;
                }
                this.parseRecord();
                String[] row = this.output.rowParsed();
                if (row == null) continue;
                this.processor.rowProcessed(row, this.context);
                if (this.recordsToRead <= 0 || this.context.currentRecord() < (long)this.recordsToRead) continue;
                this.context.stop();
            }
        }
        catch (EOFException ex) {
            this.handleEOF();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            this.stopParsing();
        }
    }

    private final String[] handleEOF() {
        String[] row = null;
        if (this.output.column != 0) {
            if (this.output.appender.length() > 0) {
                this.output.valueParsed();
            } else {
                this.output.emptyParsed();
            }
            row = this.output.rowParsed();
        } else if (this.output.appender.length() > 0) {
            this.output.valueParsed();
            row = this.output.rowParsed();
        }
        if (row != null) {
            this.processor.rowProcessed(row, this.context);
        }
        return row;
    }

    public final void beginParsing(Reader reader) {
        this.input = reader instanceof LineReader ? new DefaultCharInputReader(((Format)((CommonSettings)this.settings).getFormat()).getLineSeparator(), ((Format)((CommonSettings)this.settings).getFormat()).getNormalizedNewline(), ((CommonParserSettings)this.settings).getInputBufferSize()) : ((CommonParserSettings)this.settings).newCharInputReader();
        this.context = new DefaultParsingContext(this.input, this.output);
        this.context.stopped = false;
        this.input.start(reader);
        this.processor.processStarted(this.context);
    }

    public final String[] parseNext() {
        try {
            while (!this.context.stopped) {
                this.ch = this.input.nextChar();
                if (this.ch == this.comment) {
                    this.input.skipLines(1);
                    continue;
                }
                this.parseRecord();
                String[] row = this.output.rowParsed();
                if (row == null) continue;
                this.processor.rowProcessed(row, this.context);
                if (this.recordsToRead > 0 && this.context.currentRecord() >= (long)this.recordsToRead) {
                    this.context.stop();
                }
                return row;
            }
            this.stopParsing();
            return null;
        }
        catch (EOFException ex) {
            String[] row = this.handleEOF();
            this.stopParsing();
            return row;
        }
        catch (NullPointerException ex) {
            if (this.context == null) {
                throw new IllegalStateException("Cannot parse without invoking method beginParsing(Reader) first");
            }
            if (this.input != null) {
                this.stopParsing();
            }
            throw new IllegalStateException("Error parsing next record.", ex);
        }
        catch (Exception ex) {
            try {
                throw this.handleException(ex);
            }
            catch (Throwable throwable2) {
                this.stopParsing();
                throw throwable2;
            }
        }
    }

    private String displayLineSeparators(String str, boolean addNewLine) {
        if (addNewLine) {
            str = str.contains("\r\n") ? str.replaceAll("\\r\\n", "[\\\\r\\\\n]\r\n\t") : (str.contains("\n") ? str.replaceAll("\\n", "[\\\\n]\n\t") : str.replaceAll("\\r", "[\\\\r]\r\t"));
        } else {
            str = str.replaceAll("\\n", "\\\\n");
            str = str.replaceAll("\\r", "\\\\r");
        }
        return str;
    }

    private TextParsingException handleException(Exception ex) {
        String message = null;
        char[] chars = this.output.appender.getChars();
        if (chars != null) {
            String tmp;
            int length = this.output.appender.length();
            if (length > chars.length) {
                message = "Length of parsed input (" + length + ") exceeds the maximum number of characters defined in your parser settings (" + ((CommonSettings)this.settings).getMaxCharsPerColumn() + "). ";
                length = chars.length;
            }
            if ((tmp = new String(chars)).contains("\n") || tmp.contains("\r")) {
                tmp = this.displayLineSeparators(tmp, true);
                String lineSeparator = this.displayLineSeparators(((Format)((CommonSettings)this.settings).getFormat()).getLineSeparatorString(), false);
                message = message + "\nIdentified line separator characters in the parsed content. This may be the cause of the error. The line separator in your parser settings is set to '" + lineSeparator + "'. Parsed content:\n\t" + tmp;
            }
            int nullCharacterCount = 0;
            int maxLength = length > 0x3FFFFFFF ? 0x3FFFFFFE : length;
            StringBuilder s2 = new StringBuilder(maxLength);
            for (int i = 0; i < maxLength; ++i) {
                if (chars[i] == '\u0000') {
                    s2.append('\\');
                    s2.append('0');
                    ++nullCharacterCount;
                    continue;
                }
                s2.append(chars[i]);
            }
            tmp = s2.toString();
            if (nullCharacterCount > 0) {
                message = message + "\nIdentified " + nullCharacterCount + " null characters ('\u0000') on parsed content. This may indicate the data is corrupt or its encoding is invalid. Parsed content:\n\t" + tmp;
            }
        }
        throw new TextParsingException(this.context, message, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopParsing() {
        try {
            this.context.stop();
        }
        finally {
            try {
                this.processor.processEnded(this.context);
            }
            finally {
                this.input.stop();
            }
        }
    }

    public final List<String[]> parseAll(Reader reader) {
        ArrayList<String[]> out = new ArrayList<String[]>(10000);
        this.beginParsing(reader);
        String[] row = null;
        while ((row = this.parseNext()) != null) {
            out.add(row);
        }
        return out;
    }

    protected final void reloadHeaders() {
        this.output.initializeHeaders();
    }

    public final String[] parseLine(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        this.lineReader.setLine(line);
        if (this.context == null || this.context.isStopped()) {
            this.beginParsing(this.lineReader);
        } else {
            ((DefaultCharInputReader)this.input).reloadBuffer();
        }
        try {
            while (!this.context.stopped) {
                this.ch = this.input.nextChar();
                if (this.ch == this.comment) {
                    return null;
                }
                this.parseRecord();
                String[] row = this.output.rowParsed();
                if (row == null) continue;
                this.processor.rowProcessed(row, this.context);
                return row;
            }
            return null;
        }
        catch (EOFException ex) {
            return this.handleEOF();
        }
        catch (NullPointerException ex) {
            if (this.input != null) {
                this.stopParsing();
            }
            throw new IllegalStateException("Error parsing next record.", ex);
        }
        catch (Exception ex) {
            try {
                throw this.handleException(ex);
            }
            catch (Throwable throwable2) {
                this.stopParsing();
                throw throwable2;
            }
        }
    }
}

