/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.common.CommonWriterSettings;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.TextWritingException;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.input.CharAppender;
import com.univocity.parsers.common.input.WriterCharAppender;
import com.univocity.parsers.common.processor.RowWriterProcessor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractWriter<S extends CommonWriterSettings<?>> {
    private final RowWriterProcessor writerProcessor;
    private final BufferedWriter writer;
    private final boolean skipEmptyLines;
    private final char comment;
    private final StringBuilder freeText = new StringBuilder();
    private final WriterCharAppender rowAppender;
    private final Object[] outputRow;
    private final int[] indexesToWrite;
    private final char[] lineSeparator;
    private String[] headers;
    private long recordCount = 0L;
    protected final String nullValue;
    protected final String emptyValue;
    protected final CharAppender appender;
    private final Object[] partialLine;
    private int partialLineIndex = 0;
    private Map<String, Integer> headerIndexes;

    public AbstractWriter(Writer writer, S settings2) {
        this.nullValue = ((CommonSettings)settings2).getNullValue();
        this.emptyValue = ((CommonWriterSettings)settings2).getEmptyValue();
        this.lineSeparator = ((Format)((CommonSettings)settings2).getFormat()).getLineSeparator();
        this.comment = ((Format)((CommonSettings)settings2).getFormat()).getComment();
        this.skipEmptyLines = ((CommonSettings)settings2).getSkipEmptyLines();
        this.writerProcessor = ((CommonWriterSettings)settings2).getRowWriterProcessor();
        this.appender = new WriterCharAppender(((CommonSettings)settings2).getMaxCharsPerColumn(), "", (Format)((CommonSettings)settings2).getFormat());
        this.rowAppender = new WriterCharAppender(((CommonSettings)settings2).getMaxCharsPerColumn() * ((CommonSettings)settings2).getMaxColumns(), "", (Format)((CommonSettings)settings2).getFormat());
        this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        this.headers = ((CommonSettings)settings2).getHeaders();
        FieldSelector selector = ((CommonSettings)settings2).getFieldSelector();
        if (this.headers != null && this.headers.length > 0 && selector != null) {
            this.outputRow = new Object[this.headers.length];
            this.indexesToWrite = selector.getFieldIndexes(this.headers);
        } else {
            this.outputRow = null;
            this.indexesToWrite = null;
        }
        this.partialLine = new Object[((CommonSettings)settings2).getMaxColumns()];
    }

    protected abstract void processRow(Object[] var1);

    protected final void appendValueToRow() {
        this.rowAppender.append((WriterCharAppender)this.appender);
    }

    protected final void appendToRow(char ch) {
        this.rowAppender.append(ch);
    }

    public final void writeHeaders() {
        this.writeHeaders(this.headers);
    }

    public final void writeHeaders(Collection<String> headers) {
        if (headers != null && headers.size() > 0) {
            this.writeHeaders(headers.toArray(new String[headers.size()]));
        } else {
            this.throwExceptionAndClose("No headers defined", (Object[])null, null);
        }
    }

    public final void writeHeaders(String ... headers) {
        if (this.recordCount > 0L) {
            this.throwExceptionAndClose("Cannot write headers after records have been written", headers, null);
        }
        if (headers != null && headers.length > 0) {
            this.processRow(headers);
            this.headers = headers;
            this.writeRow();
        } else {
            this.throwExceptionAndClose("No headers defined", headers, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processRecordsAndClose(Iterable<?> allRecords) {
        try {
            this.processRecords(allRecords);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processRecordsAndClose(Object[] allRecords) {
        try {
            this.processRecords(allRecords);
        }
        finally {
            this.close();
        }
    }

    public final void processRecords(Iterable<?> records) {
        for (Object record2 : records) {
            this.processRecord(record2);
        }
    }

    public final void processRecords(Object[] records) {
        for (Object record2 : records) {
            this.processRecord(record2);
        }
    }

    public final void processRecord(Object ... record2) {
        this.processRecord((Object)record2);
    }

    public final void processRecord(Object record2) {
        if (this.writerProcessor == null) {
            try {
                throw new IllegalStateException("Cannot process record '" + record2 + "' without a writer processor. Please define a writer processor instance in the settings or use the 'writeRow' methods.");
            }
            catch (Throwable throwable2) {
                this.close();
                throw throwable2;
            }
        }
        Object[] row = this.writerProcessor.write(record2, this.headers, this.indexesToWrite);
        this.writeRow(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <C extends Collection<Object>> void writeRowsAndClose(Iterable<C> allRows) {
        try {
            this.writeRows(allRows);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeRowsAndClose(Collection<Object[]> allRows) {
        try {
            this.writeRows(allRows);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeRowsAndClose(Object[][] allRows) {
        try {
            this.writeRows(allRows);
        }
        finally {
            this.close();
        }
    }

    public final void writeRows(Object[][] rows) {
        for (Object[] row : rows) {
            this.writeRow(row);
        }
    }

    public final <C extends Collection<Object>> void writeRows(Iterable<C> rows) {
        for (Collection row : rows) {
            this.writeRow(row);
        }
    }

    public final void writeRows(Collection<Object[]> rows) {
        for (Object[] row : rows) {
            this.writeRow(row);
        }
    }

    public final void writeRow(Collection<Object> row) {
        if (row == null) {
            return;
        }
        this.writeRow(row.toArray());
    }

    public final void writeRow(Object ... row) {
        try {
            if (row == null || row.length == 0) {
                if (this.skipEmptyLines) {
                    return;
                }
                this.writeEmptyRow();
                return;
            }
            if (this.outputRow != null) {
                this.fillOutputRow(row);
                row = this.outputRow;
            }
            this.processRow(row);
            this.writeRow();
        }
        catch (Exception ex) {
            this.throwExceptionAndClose("Error writing empty row", row, ex);
        }
    }

    public final void writeRow(String row) {
        this.freeText.setLength(0);
        this.freeText.append(row);
        this.writeToOutput(this.freeText.toString());
    }

    public final void writeEmptyRow() {
        try {
            this.writer.write(this.lineSeparator);
        }
        catch (IOException ex) {
            this.throwExceptionAndClose("Error writing empty row", Arrays.toString(this.lineSeparator), (Exception)ex);
        }
    }

    public final void commentRow(String comment2) {
        this.writeRow(this.comment + comment2);
    }

    private final <T> void fillOutputRow(T[] row) {
        if (row.length > this.indexesToWrite.length) {
            String msg = "Cannot write row as it contains more elements than the number of selected fields (" + this.indexesToWrite.length + " fields selected)";
            this.throwExceptionAndClose(msg, this.headers, null);
        }
        for (int i = 0; i < this.indexesToWrite.length && i < row.length; ++i) {
            this.outputRow[this.indexesToWrite[i]] = row[i];
        }
    }

    private final void writeRow() {
        try {
            this.rowAppender.appendNewLine();
            this.rowAppender.writeCharsAndReset(this.writer);
            ++this.recordCount;
        }
        catch (Exception ex) {
            this.throwExceptionAndClose("Error writing row", this.rowAppender.getAndReset(), ex);
        }
    }

    private final void writeToOutput(String row) {
        try {
            this.writer.write(row);
            this.writer.write(this.lineSeparator);
        }
        catch (IOException ex) {
            this.throwExceptionAndClose("Error writing row", row, (Exception)ex);
        }
    }

    protected final int skipLeadingWhitespace(String element) {
        for (int i = 0; i < element.length(); ++i) {
            char nextChar = element.charAt(i);
            if (nextChar <= ' ') continue;
            return i;
        }
        return 0;
    }

    public final void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception ex) {
            this.throwExceptionAndClose("Error flushing output", this.rowAppender.getAndReset(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            this.headerIndexes = null;
            try {
                this.writer.flush();
            }
            finally {
                this.writer.close();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error closing the output.", ex);
        }
    }

    private void throwExceptionAndClose(String message, String recordCharacters, Exception cause) {
        try {
            throw new TextWritingException(message, this.recordCount, recordCharacters, (Throwable)cause);
        }
        catch (Throwable throwable2) {
            this.close();
            throw throwable2;
        }
    }

    private void throwExceptionAndClose(String message, Object[] recordValues, Exception cause) {
        try {
            throw new TextWritingException(message, this.recordCount, recordValues, (Throwable)cause);
        }
        catch (Throwable throwable2) {
            this.close();
            throw throwable2;
        }
    }

    protected String getStringValue(Object element) {
        if (element == null && (element = this.nullValue) == null) {
            return null;
        }
        String string2 = String.valueOf(element);
        if (string2.isEmpty()) {
            return this.emptyValue;
        }
        return string2;
    }

    public final void writeValues(Object ... values2) {
        System.arraycopy(values2, 0, this.partialLine, this.partialLineIndex, values2.length);
        this.partialLineIndex += values2.length;
    }

    public final void writeValue(Object value2) {
        this.partialLine[this.partialLineIndex++] = value2;
    }

    public final void writeValuesToRow() {
        this.writeRow(Arrays.copyOf(this.partialLine, this.partialLineIndex + 1));
        this.partialLineIndex = 0;
    }

    public final void writeValue(int index2, Object value2) {
        this.partialLine[index2] = value2;
        if (this.partialLineIndex < index2) {
            this.partialLineIndex = index2;
        }
    }

    public final void writeValue(String headerName, Object value2) {
        this.writeValue(this.getFieldIndex(headerName), value2);
    }

    private int getFieldIndex(String headerName) {
        Integer index2;
        if (this.headerIndexes == null) {
            this.headerIndexes = new HashMap<String, Integer>();
        }
        if ((index2 = this.headerIndexes.get(headerName)) == null) {
            if (this.headers == null) {
                throw new IllegalArgumentException("Cannot calculate position of header '" + headerName + "' as no headers were defined");
            }
            index2 = ArgumentUtils.indexOf(ArgumentUtils.normalize(this.headers), ArgumentUtils.normalize(headerName));
            if (index2 == -1) {
                throw new IllegalArgumentException("Header '" + headerName + "' could not be found. Defined headers are: " + Arrays.toString(this.headers));
            }
            this.headerIndexes.put(headerName, index2);
        }
        return index2;
    }

    public final void discardValues() {
        this.partialLineIndex = 0;
    }
}

