/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.ParserOutput;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.input.CharInputReader;

class DefaultParsingContext
implements ParsingContext {
    private final CharInputReader input;
    private final ParserOutput output;
    protected boolean stopped = false;
    private int[] extractedIndexes = null;

    public DefaultParsingContext(CharInputReader input2, ParserOutput output) {
        this.input = input2;
        this.output = output;
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public long currentLine() {
        return this.input.lineCount();
    }

    @Override
    public long currentChar() {
        return this.input.charCount();
    }

    @Override
    public int currentColumn() {
        return this.output.getCurrentColumn();
    }

    @Override
    public String[] headers() {
        return this.output.getHeaders();
    }

    @Override
    public int[] extractedFieldIndexes() {
        if (this.extractedIndexes == null) {
            this.extractedIndexes = this.output.getSelectedIndexes();
        }
        return this.extractedIndexes;
    }

    @Override
    public boolean columnsReordered() {
        return this.output.isColumnReorderingEnabled();
    }

    @Override
    public void skipLines(int lines2) {
        this.input.skipLines(lines2);
    }

    @Override
    public long currentRecord() {
        return this.output.getCurrentRecord();
    }

    @Override
    public String currentParsedContent() {
        char[] chars = this.output.appender.getChars();
        if (chars != null) {
            int length = this.output.appender.length();
            if (length > chars.length) {
                length = chars.length;
            }
            if (length > 0) {
                return new String(chars, 0, length);
            }
        }
        return null;
    }
}

