/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.input.CharAppender;
import com.univocity.parsers.common.input.NoopCharAppender;
import java.util.Arrays;

public class ParserOutput {
    int column = 0;
    private final String[] parsedValues;
    private CharAppender[] appenders;
    private final CommonParserSettings<?> settings;
    private final boolean skipEmptyLines;
    private final String nullValue;
    public CharAppender appender;
    private boolean columnsToExtractInitialized;
    private boolean columnsReordered;
    private String[] headers;
    private int[] selectedIndexes;
    private long currentRecord;

    public ParserOutput(CommonParserSettings<?> settings2) {
        this.appender = settings2.newCharAppender();
        this.parsedValues = new String[settings2.getMaxColumns()];
        this.appenders = new CharAppender[settings2.getMaxColumns()];
        Arrays.fill(this.appenders, this.appender);
        this.settings = settings2;
        this.skipEmptyLines = settings2.getSkipEmptyLines();
        this.nullValue = settings2.getNullValue();
        this.columnsToExtractInitialized = false;
        this.currentRecord = 0L;
    }

    void initializeHeaders() {
        this.columnsToExtractInitialized = true;
        this.columnsReordered = false;
        this.selectedIndexes = null;
        this.appender = this.settings.newCharAppender();
        Arrays.fill(this.appenders, this.appender);
        this.headers = this.settings.getHeaders();
        if (this.headers != null) {
            this.headers = (String[])this.headers.clone();
            this.initializeColumnsToExtract(this.headers);
        } else if (this.column > 0) {
            this.initializeColumnsToExtract(Arrays.copyOf(this.parsedValues, this.column));
            if (this.settings.isHeaderExtractionEnabled()) {
                this.headers = new String[this.column];
                System.arraycopy(this.parsedValues, 0, this.headers, 0, this.column);
            }
        }
    }

    public String[] rowParsed() {
        if (this.column > 0) {
            if (!this.columnsToExtractInitialized) {
                this.initializeHeaders();
                if (this.settings.isHeaderExtractionEnabled()) {
                    Arrays.fill(this.parsedValues, null);
                    this.column = 0;
                    this.appender = this.appenders[0];
                    return null;
                }
            }
            ++this.currentRecord;
            if (this.columnsReordered) {
                String[] reorderedValues = new String[this.selectedIndexes.length];
                for (int i = 0; i < this.selectedIndexes.length; ++i) {
                    int index2 = this.selectedIndexes[i];
                    reorderedValues[i] = index2 >= this.column ? this.nullValue : this.parsedValues[index2];
                }
                this.column = 0;
                this.appender = this.appenders[0];
                return reorderedValues;
            }
            String[] out = new String[this.column];
            System.arraycopy(this.parsedValues, 0, out, 0, this.column);
            this.column = 0;
            this.appender = this.appenders[0];
            return out;
        }
        if (!this.skipEmptyLines) {
            if (!this.columnsToExtractInitialized) {
                this.initializeHeaders();
            }
            ++this.currentRecord;
            if (this.columnsReordered) {
                Object[] out = new String[this.selectedIndexes.length];
                Arrays.fill(out, this.nullValue);
                return out;
            }
            return ArgumentUtils.EMPTY_STRING_ARRAY;
        }
        return null;
    }

    private void initializeColumnsToExtract(String[] values2) {
        FieldSelector selector = this.settings.getFieldSelector();
        if (selector != null) {
            this.selectedIndexes = selector.getFieldIndexes(values2);
            if (this.selectedIndexes != null) {
                Arrays.fill(this.appenders, NoopCharAppender.getInstance());
                for (int i = 0; i < this.selectedIndexes.length; ++i) {
                    this.appenders[this.selectedIndexes[i]] = this.appender;
                }
                this.columnsReordered = this.settings.isColumnReorderingEnabled();
                if (!this.columnsReordered && values2.length < this.appenders.length) {
                    Arrays.fill(this.appenders, values2.length, this.appenders.length, this.appender);
                }
            }
        }
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public int[] getSelectedIndexes() {
        return this.selectedIndexes;
    }

    public boolean isColumnReorderingEnabled() {
        return this.columnsReordered;
    }

    public int getCurrentColumn() {
        return this.column;
    }

    public void emptyParsed() {
        this.parsedValues[this.column++] = this.nullValue;
        this.appender = this.appenders[this.column];
    }

    public void valueParsed() {
        this.parsedValues[this.column++] = this.appender.getAndReset();
        this.appender = this.appenders[this.column];
    }

    public long getCurrentRecord() {
        return this.currentRecord;
    }

    public final void discardValues() {
        this.column = 0;
        this.appender = this.appenders[0];
    }
}

