/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.fields;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.fields.FieldSet;
import com.univocity.parsers.conversions.Conversion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractConversionMapping<T> {
    private Map<FieldSelector, Conversion<String, ?>[]> conversionsMap;
    private final List<FieldSelector> conversionSequence;

    AbstractConversionMapping(List<FieldSelector> conversionSequence) {
        this.conversionSequence = conversionSequence;
    }

    public FieldSet<T> registerConversions(Conversion<String, ?> ... conversions) {
        ArgumentUtils.noNulls("Conversions", conversions);
        FieldSelector selector = this.newFieldSelector();
        if (this.conversionsMap == null) {
            this.conversionsMap = new LinkedHashMap<FieldSelector, Conversion<String, ?>[]>();
        }
        this.conversionsMap.put(selector, conversions);
        this.conversionSequence.add(selector);
        if (selector instanceof FieldSet) {
            return (FieldSet)((Object)selector);
        }
        return null;
    }

    protected abstract FieldSelector newFieldSelector();

    public void prepareExecution(FieldSelector selector, Map<Integer, List<Conversion<?, ?>>> conversionsByIndex, String[] values2) {
        int[] fieldIndexes;
        if (this.conversionsMap == null) {
            return;
        }
        Conversion<String, ?>[] conversions = this.conversionsMap.get(selector);
        if (conversions == null) {
            return;
        }
        for (int fieldIndex : fieldIndexes = selector.getFieldIndexes(values2)) {
            List<Conversion<?, ?>> conversionsAtIndex = conversionsByIndex.get(fieldIndex);
            if (conversionsAtIndex == null) {
                conversionsAtIndex = new ArrayList();
                conversionsByIndex.put(fieldIndex, conversionsAtIndex);
            }
            this.validateDuplicates(selector, conversionsAtIndex, conversions);
            conversionsAtIndex.addAll(Arrays.asList(conversions));
        }
    }

    private void validateDuplicates(FieldSelector selector, List<Conversion<?, ?>> conversionsAtIndex, Conversion<?, ?>[] conversionsToAdd) {
        for (Conversion<?, ?> toAdd : conversionsToAdd) {
            for (Conversion<?, ?> existing : conversionsAtIndex) {
                if (toAdd != existing) continue;
                throw new IllegalArgumentException("Duplicate conversion " + toAdd.getClass().getName() + " being applied to " + selector.describe());
            }
        }
    }

    public boolean isEmpty() {
        return this.conversionsMap == null || this.conversionsMap.isEmpty();
    }
}

