/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.fields;

import com.univocity.parsers.common.fields.AbstractConversionMapping;
import com.univocity.parsers.common.fields.AllIndexesSelector;
import com.univocity.parsers.common.fields.FieldIndexSelector;
import com.univocity.parsers.common.fields.FieldNameSelector;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.fields.FieldSet;
import com.univocity.parsers.conversions.Conversion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldConversionMapping {
    private List<FieldSelector> conversionSequence = new ArrayList<FieldSelector>();
    private AbstractConversionMapping<String> fieldNameConversionMapping = new AbstractConversionMapping<String>(this.conversionSequence){

        @Override
        protected FieldSelector newFieldSelector() {
            return new FieldNameSelector();
        }
    };
    private AbstractConversionMapping<Integer> fieldIndexConversionMapping = new AbstractConversionMapping<Integer>(this.conversionSequence){

        @Override
        protected FieldSelector newFieldSelector() {
            return new FieldIndexSelector();
        }
    };
    private AbstractConversionMapping<Integer> convertAllMapping = new AbstractConversionMapping<Integer>(this.conversionSequence){

        @Override
        protected FieldSelector newFieldSelector() {
            return new AllIndexesSelector();
        }
    };
    private Map<Integer, List<Conversion<?, ?>>> conversionsByIndex = Collections.emptyMap();

    public void prepareExecution(String[] values2) {
        if (this.fieldNameConversionMapping.isEmpty() && this.fieldIndexConversionMapping.isEmpty() && this.convertAllMapping.isEmpty()) {
            return;
        }
        if (!this.conversionsByIndex.isEmpty()) {
            return;
        }
        this.conversionsByIndex = new HashMap();
        for (FieldSelector next2 : this.conversionSequence) {
            this.fieldNameConversionMapping.prepareExecution(next2, this.conversionsByIndex, values2);
            this.fieldIndexConversionMapping.prepareExecution(next2, this.conversionsByIndex, values2);
            this.convertAllMapping.prepareExecution(next2, this.conversionsByIndex, values2);
        }
    }

    public void applyConversionsOnAllFields(Conversion<String, ?> ... conversions) {
        this.convertAllMapping.registerConversions(conversions);
    }

    public FieldSet<Integer> applyConversionsOnFieldIndexes(Conversion<String, ?> ... conversions) {
        return this.fieldIndexConversionMapping.registerConversions(conversions);
    }

    public FieldSet<String> applyConversionsOnFieldNames(Conversion<String, ?> ... conversions) {
        return this.fieldNameConversionMapping.registerConversions(conversions);
    }

    public Object reverseConversions(boolean executeInReverseOrder, int index2, Object value2) {
        List<Conversion<?, ?>> conversions = this.conversionsByIndex.get(index2);
        if (conversions != null) {
            Conversion<?, ?> conversion = null;
            try {
                if (executeInReverseOrder) {
                    for (int i = conversions.size() - 1; i >= 0; --i) {
                        conversion = conversions.get(i);
                        value2 = conversion.revert(value2);
                    }
                } else {
                    for (Conversion<?, ?> c : conversions) {
                        conversion = c;
                        value2 = conversion.revert(value2);
                    }
                }
            }
            catch (Exception ex) {
                if (conversion != null) {
                    throw new IllegalStateException("Error converting value '" + value2 + "' using conversion " + conversion.getClass().getName(), ex);
                }
                throw new IllegalStateException("Error converting value '" + value2 + "'", ex);
            }
        }
        return value2;
    }

    public Object applyConversions(int index2, String stringValue) {
        List<Conversion<?, ?>> conversions = this.conversionsByIndex.get(index2);
        if (conversions != null) {
            String result2 = stringValue;
            for (Conversion<?, ?> conversion : conversions) {
                try {
                    result2 = conversion.execute(result2);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Error converting value '" + result2 + "' using conversion " + conversion.getClass().getName(), ex);
                }
            }
            return result2;
        }
        return stringValue;
    }
}

