/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.fields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FieldSet<T> {
    private final List<T> fields = new ArrayList<T>();

    List<T> get() {
        return new ArrayList<T>(this.fields);
    }

    private void addElement(T field2) {
        if (this.fields.contains(field2)) {
            throw new IllegalArgumentException("Field '" + field2 + "' is already selection");
        }
        this.fields.add(field2);
    }

    public FieldSet<T> add(T ... fields) {
        for (T field2 : fields) {
            this.addElement(field2);
        }
        return this;
    }

    public FieldSet<T> set(T ... fields) {
        this.fields.clear();
        this.add(fields);
        return this;
    }

    public FieldSet<T> add(Collection<T> fields) {
        for (T field2 : fields) {
            this.addElement(field2);
        }
        return this;
    }

    public FieldSet<T> set(Collection<T> fields) {
        this.fields.clear();
        this.add(fields);
        return this;
    }

    public FieldSet<T> remove(T ... fields) {
        for (T field2 : fields) {
            this.fields.remove(field2);
        }
        return this;
    }

    public FieldSet<T> remove(Collection<T> fields) {
        this.fields.removeAll(fields);
        return this;
    }

    public String describe() {
        return "field selection: " + this.fields.toString();
    }
}

