/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.input.concurrent;

import com.univocity.parsers.common.input.concurrent.Entry;

abstract class FixedInstancePool<T> {
    final Entry<T>[] instancePool;
    private final int[] instanceIndexes;
    private int head = 0;
    private int tail = 0;
    int count = 0;

    FixedInstancePool(int size2) {
        this.instancePool = new Entry[size2];
        this.instanceIndexes = new int[size2];
        for (int i = 0; i < size2; ++i) {
            this.instancePool[i] = new Entry<T>(this.newInstance(), i);
            this.instanceIndexes[i] = i;
        }
    }

    protected abstract T newInstance();

    public synchronized Entry<T> allocate() {
        while (this.count == this.instancePool.length) {
            try {
                this.wait(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Thread interrupted", e);
            }
        }
        if (this.count == this.instancePool.length) {
            return new Entry<T>(this.newInstance(), -1);
        }
        Entry<T> out = this.instancePool[this.instanceIndexes[this.head]];
        ++this.head;
        if (this.head == this.instancePool.length) {
            this.head = 0;
        }
        ++this.count;
        return out;
    }

    public synchronized void release(Entry<T> e) {
        if (e.index != -1) {
            this.instanceIndexes[this.tail++] = e.index;
            if (this.tail == this.instancePool.length) {
                this.tail = 0;
            }
            --this.count;
        }
        this.notify();
    }
}

