/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.processor;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.ParsingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ColumnSplitter<T> {
    private List<List<T>> columnValues;
    private String[] headers = null;
    private int expectedRowCount = 1000;
    private long rowCount;
    private long addNullsFrom;

    ColumnSplitter(int expectedRowCount) {
        if (expectedRowCount <= 0) {
            throw new IllegalArgumentException("Expected row count must be positive");
        }
        this.expectedRowCount = expectedRowCount;
    }

    void clearValues() {
        this.addNullsFrom = this.rowCount;
        this.columnValues = null;
    }

    void reset() {
        this.columnValues = null;
        this.headers = null;
        this.addNullsFrom = 0L;
        this.rowCount = 0L;
    }

    List<List<T>> getColumnValues() {
        return this.columnValues;
    }

    String[] getHeaders() {
        return this.headers;
    }

    private void initialize(ParsingContext context) {
        if (this.headers == null) {
            String[] allHeaders = context.headers();
            if (allHeaders == null) {
                this.headers = ArgumentUtils.EMPTY_STRING_ARRAY;
            } else if (!context.columnsReordered()) {
                this.headers = allHeaders;
            } else {
                int[] selectedIndexes = context.extractedFieldIndexes();
                int last2 = Math.min(allHeaders.length, selectedIndexes.length);
                this.headers = new String[selectedIndexes.length];
                for (int i = 0; i < last2; ++i) {
                    this.headers[i] = allHeaders[selectedIndexes[i]];
                }
            }
        }
        this.columnValues = new ArrayList<List<T>>(this.headers.length > 0 ? this.headers.length : 10);
    }

    String getHeader(int columnIndex) {
        if (columnIndex < this.headers.length) {
            return this.headers[columnIndex];
        }
        return null;
    }

    void addValuesToColumns(T[] row, ParsingContext context) {
        int i;
        if (this.columnValues == null) {
            this.initialize(context);
        }
        if (this.columnValues.size() < row.length) {
            int columnsToAdd = row.length - this.columnValues.size();
            while (columnsToAdd-- > 0) {
                long records = context.currentRecord() - this.addNullsFrom;
                ArrayList<Object> values2 = new ArrayList<Object>((long)this.expectedRowCount < records ? (int)records : this.expectedRowCount);
                while (--records > 0L) {
                    values2.add(null);
                }
                this.columnValues.add(values2);
            }
        }
        for (i = 0; i < row.length; ++i) {
            this.columnValues.get(i).add(row[i]);
        }
        if (row.length < this.columnValues.size()) {
            for (i = row.length; i < this.columnValues.size(); ++i) {
                this.columnValues.get(i).add(null);
            }
        }
        ++this.rowCount;
    }

    void putColumnValuesInMapOfNames(Map<String, List<T>> map2) {
        if (this.columnValues == null) {
            return;
        }
        for (int i = 0; i < this.columnValues.size(); ++i) {
            String header = this.getHeader(i);
            if (header == null) {
                throw new IllegalArgumentException("Parsed input does not have header for column at index '" + i + "'. Parsed header names: " + Arrays.toString(this.getHeaders()));
            }
            map2.put(header, this.columnValues.get(i));
        }
    }

    void putColumnValuesInMapOfIndexes(Map<Integer, List<T>> map2) {
        if (this.columnValues == null) {
            return;
        }
        for (int i = 0; i < this.columnValues.size(); ++i) {
            map2.put(i, this.columnValues.get(i));
        }
    }

    Map<String, List<T>> getColumnValuesAsMapOfNames() {
        HashMap<String, List<T>> map2 = new HashMap<String, List<T>>();
        this.putColumnValuesInMapOfNames(map2);
        return map2;
    }

    Map<Integer, List<T>> getColumnValuesAsMapOfIndexes() {
        HashMap<Integer, List<T>> map2 = new HashMap<Integer, List<T>>();
        this.putColumnValuesInMapOfIndexes(map2);
        return map2;
    }
}

