/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.processor;

import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.fields.FieldConversionMapping;
import com.univocity.parsers.common.fields.FieldSet;
import com.univocity.parsers.conversions.Conversion;

abstract class ConversionProcessor {
    private FieldConversionMapping conversions;
    private boolean conversionsInitialized;
    private int[] fieldIndexes;
    private boolean fieldsReordered;

    ConversionProcessor() {
    }

    public final FieldSet<Integer> convertIndexes(Conversion ... conversions) {
        return this.getConversions().applyConversionsOnFieldIndexes(conversions);
    }

    public final void convertAll(Conversion ... conversions) {
        this.getConversions().applyConversionsOnAllFields(conversions);
    }

    public final FieldSet<String> convertFields(Conversion ... conversions) {
        return this.getConversions().applyConversionsOnFieldNames(conversions);
    }

    private FieldConversionMapping getConversions() {
        if (this.conversions == null) {
            this.conversions = new FieldConversionMapping();
        }
        return this.conversions;
    }

    private void initializeConversions(String[] row, ParsingContext context) {
        this.conversionsInitialized = true;
        this.fieldIndexes = null;
        this.fieldsReordered = false;
        this.conversionsInitialized = false;
        if (context.headers() != null) {
            this.conversions.prepareExecution(context.headers());
        } else {
            this.conversions.prepareExecution(row);
        }
        this.fieldIndexes = context.extractedFieldIndexes();
        this.fieldsReordered = context.columnsReordered();
    }

    public final Object[] applyConversions(String[] row, ParsingContext context) {
        Object[] objectRow;
        block8: {
            objectRow = new Object[row.length];
            System.arraycopy(row, 0, objectRow, 0, row.length);
            if (this.conversions == null) break block8;
            if (!this.conversionsInitialized) {
                this.initializeConversions(row, context);
            }
            if (!this.fieldsReordered) {
                if (this.fieldIndexes == null) {
                    for (int i = 0; i < objectRow.length; ++i) {
                        objectRow[i] = this.conversions.applyConversions(i, row[i]);
                    }
                } else {
                    for (int i = 0; i < this.fieldIndexes.length; ++i) {
                        int index2 = this.fieldIndexes[i];
                        objectRow[index2] = this.conversions.applyConversions(index2, row[index2]);
                    }
                }
            } else {
                for (int i = 0; i < this.fieldIndexes.length; ++i) {
                    objectRow[i] = this.conversions.applyConversions(this.fieldIndexes[i], row[i]);
                }
            }
        }
        return objectRow;
    }

    public final void reverseConversions(boolean executeInReverseOrder, Object[] row, String[] headers, int[] indexesToWrite) {
        block5: {
            if (this.conversions == null) break block5;
            if (!this.conversionsInitialized) {
                this.conversionsInitialized = true;
                this.conversions.prepareExecution(headers);
                this.fieldIndexes = indexesToWrite;
            }
            if (this.fieldIndexes == null) {
                for (int i = 0; i < row.length; ++i) {
                    row[i] = this.conversions.reverseConversions(executeInReverseOrder, i, row[i]);
                }
            } else {
                for (int i = 0; i < this.fieldIndexes.length; ++i) {
                    int index2 = this.fieldIndexes[i];
                    row[index2] = this.conversions.reverseConversions(executeInReverseOrder, index2, row[index2]);
                }
            }
        }
    }
}

