/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.conversions;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.conversions.DateConversion;
import com.univocity.parsers.conversions.FormattedConversion;
import com.univocity.parsers.conversions.ObjectConversion;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CalendarConversion
extends ObjectConversion<Calendar>
implements FormattedConversion<SimpleDateFormat> {
    private final DateConversion dateConversion;

    public CalendarConversion(Calendar valueIfStringIsNull, String valueIfObjectIsNull, String ... dateFormats) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
        ArgumentUtils.noNulls("Date formats", dateFormats);
        this.dateConversion = new DateConversion(dateFormats);
    }

    public CalendarConversion(String ... dateFormats) {
        this((Calendar)null, (String)null, dateFormats);
    }

    @Override
    public String revert(Calendar input2) {
        if (input2 == null) {
            return super.revert(input2);
        }
        return this.dateConversion.revert(input2.getTime());
    }

    @Override
    protected Calendar fromString(String input2) {
        Date date = (Date)this.dateConversion.execute(input2);
        Calendar out = Calendar.getInstance();
        out.setTime(date);
        return out;
    }

    public SimpleDateFormat[] getFormatterObjects() {
        return this.dateConversion.getFormatterObjects();
    }
}

