/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.conversions;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.conversions.FormattedConversion;
import com.univocity.parsers.conversions.ObjectConversion;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class DateConversion
extends ObjectConversion<Date>
implements FormattedConversion<SimpleDateFormat> {
    private final SimpleDateFormat[] parsers;
    private final String[] formats;

    public DateConversion(Date valueIfStringIsNull, String valueIfObjectIsNull, String ... dateFormats) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
        ArgumentUtils.noNulls("Date formats", dateFormats);
        this.formats = (String[])dateFormats.clone();
        this.parsers = new SimpleDateFormat[dateFormats.length];
        for (int i = 0; i < dateFormats.length; ++i) {
            String dateFormat = dateFormats[i];
            this.parsers[i] = new SimpleDateFormat(dateFormat);
        }
    }

    public DateConversion(String ... dateFormats) {
        this((Date)null, (String)null, dateFormats);
    }

    @Override
    public String revert(Date input2) {
        if (input2 == null) {
            return super.revert(input2);
        }
        return this.parsers[0].format(input2);
    }

    @Override
    protected Date fromString(String input2) {
        for (SimpleDateFormat formatter : this.parsers) {
            try {
                return formatter.parse(input2);
            }
            catch (ParseException ex) {
            }
        }
        throw new IllegalArgumentException("Cannot parse '" + input2 + "' as a valid date. Supported formats are: " + Arrays.toString(this.formats));
    }

    public SimpleDateFormat[] getFormatterObjects() {
        return this.parsers;
    }
}

