/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.conversions;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.conversions.FormattedConversion;
import com.univocity.parsers.conversions.ObjectConversion;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;

public abstract class NumericConversion<T extends Number>
extends ObjectConversion<T>
implements FormattedConversion<DecimalFormat> {
    private final DecimalFormat[] formatters;
    private final String[] formats;

    public NumericConversion(T valueIfStringIsNull, String valueIfObjectIsNull, String ... numericFormats) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
        ArgumentUtils.noNulls("Numeric formats", numericFormats);
        this.formats = (String[])numericFormats.clone();
        this.formatters = new DecimalFormat[numericFormats.length];
        for (int i = 0; i < numericFormats.length; ++i) {
            String numericFormat = numericFormats[i];
            this.formatters[i] = new DecimalFormat(numericFormat);
            this.configureFormatter(this.formatters[i]);
        }
    }

    public DecimalFormat[] getFormatterObjects() {
        return this.formatters;
    }

    public NumericConversion(String ... numericFormats) {
        this((null), (String)null, numericFormats);
    }

    protected abstract void configureFormatter(DecimalFormat var1);

    @Override
    protected T fromString(String input2) {
        for (DecimalFormat formatter : this.formatters) {
            try {
                return (T)formatter.parse(input2);
            }
            catch (ParseException ex) {
            }
        }
        throw new IllegalArgumentException("Cannot parse '" + input2 + "' as a valid number. Supported formats are: " + Arrays.toString(this.formats));
    }

    @Override
    public String revert(T input2) {
        if (input2 == null) {
            return super.revert((Object)input2);
        }
        for (DecimalFormat formatter : this.formatters) {
            try {
                return formatter.format(input2);
            }
            catch (Exception ex) {
            }
        }
        throw new IllegalStateException("Cannot format '" + input2 + "'. No valid formatters were defined.");
    }
}

