/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.csv;

import com.univocity.parsers.common.AbstractWriter;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.Writer;

public class CsvWriter
extends AbstractWriter<CsvWriterSettings> {
    private final char separator;
    private final char quotechar;
    private final char escapechar;
    private final boolean ignoreLeading;
    private final boolean ignoreTrailing;
    private final boolean quoteAllFields;
    private final char newLine;

    public CsvWriter(Writer writer, CsvWriterSettings settings2) {
        super(writer, settings2);
        CsvFormat format2 = (CsvFormat)settings2.getFormat();
        this.separator = format2.getDelimiter();
        this.quotechar = format2.getQuote();
        this.escapechar = format2.getQuoteEscape();
        this.newLine = format2.getNormalizedNewline();
        this.quoteAllFields = settings2.getQuoteAllFields();
        this.ignoreLeading = settings2.getIgnoreLeadingWhitespaces();
        this.ignoreTrailing = settings2.getIgnoreTrailingWhitespaces();
    }

    @Override
    protected void processRow(Object[] row) {
        for (int i = 0; i < row.length; ++i) {
            String nextElement;
            boolean isElementQuoted;
            if (i != 0) {
                this.appendToRow(this.separator);
            }
            if (isElementQuoted = this.quoteElement(nextElement = this.getStringValue(row[i]))) {
                this.appender.append(this.quotechar);
            }
            int originalLength = this.appender.length();
            this.append(isElementQuoted, nextElement);
            if (this.appender.length() == originalLength && this.nullValue != null && !this.nullValue.isEmpty()) {
                if (isElementQuoted) {
                    this.append(isElementQuoted, this.emptyValue);
                } else {
                    this.append(isElementQuoted, this.nullValue);
                }
            }
            if (isElementQuoted) {
                this.appendValueToRow();
                this.appendToRow(this.quotechar);
                continue;
            }
            this.appendValueToRow();
        }
    }

    private boolean quoteElement(String nextElement) {
        if (this.quoteAllFields) {
            return true;
        }
        if (nextElement == null) {
            return false;
        }
        for (int j = 0; j < nextElement.length(); ++j) {
            char nextChar = nextElement.charAt(j);
            if (nextChar != this.separator && nextChar != this.newLine) continue;
            return true;
        }
        return false;
    }

    private void append(boolean isElementQuoted, String element) {
        if (element == null) {
            element = this.nullValue;
        }
        if (element == null) {
            return;
        }
        int start = 0;
        if (this.ignoreLeading) {
            start = this.skipLeadingWhitespace(element);
        }
        if (this.ignoreTrailing) {
            for (int i = start; i < element.length(); ++i) {
                char nextChar = element.charAt(i);
                if (isElementQuoted && nextChar == this.quotechar) {
                    this.appender.appendIgnoringWhitespace(this.escapechar);
                }
                this.appender.appendIgnoringWhitespace(nextChar);
            }
        } else {
            for (int i = start; i < element.length(); ++i) {
                char nextChar = element.charAt(i);
                if (isElementQuoted && nextChar == this.quotechar) {
                    this.appender.append(this.escapechar);
                }
                this.appender.append(nextChar);
            }
        }
    }
}

