/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.fixed;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FixedWidthFieldLengths {
    private final List<Integer> fieldLengths = new ArrayList<Integer>();
    private final List<String> fieldNames = new ArrayList<String>();
    private boolean noNames = true;

    public FixedWidthFieldLengths(LinkedHashMap<String, Integer> fields) {
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("Map of fields and their lengths cannot be null/empty");
        }
        for (Map.Entry<String, Integer> entry2 : fields.entrySet()) {
            String fieldName = entry2.getKey();
            Integer fieldLength = entry2.getValue();
            this.addField(fieldName, fieldLength);
        }
    }

    public FixedWidthFieldLengths(int ... fieldLengths) {
        for (int i = 0; i < fieldLengths.length; ++i) {
            this.addField(fieldLengths[i]);
        }
    }

    public FixedWidthFieldLengths addField(int length) {
        return this.addField(null, length);
    }

    public FixedWidthFieldLengths addField(String name, int length) {
        this.validateLength(name, length);
        this.fieldLengths.add(length);
        this.fieldNames.add(name);
        if (name != null) {
            this.noNames = false;
        }
        return this;
    }

    private void validateLength(String name, int length) {
        if (length < 1) {
            if (name == null) {
                throw new IllegalArgumentException("Invalid field length: " + length + " for field at index " + this.fieldLengths.size());
            }
            throw new IllegalArgumentException("Invalid field length: " + length + " for field " + name);
        }
    }

    public int getFieldsPerRecord() {
        return this.fieldLengths.size();
    }

    public String[] getFieldNames() {
        if (this.noNames) {
            return null;
        }
        return this.fieldNames.toArray(new String[this.fieldNames.size()]);
    }

    public int[] getFieldLengths() {
        int[] lengths = new int[this.fieldLengths.size()];
        for (int i = 0; i < this.fieldLengths.size(); ++i) {
            lengths[i] = this.fieldLengths.get(i);
        }
        return lengths;
    }

    public void setFieldLength(String name, int newLength) {
        if (name == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        int index2 = this.fieldNames.indexOf(name);
        if (index2 == -1) {
            throw new IllegalArgumentException("Cannot find field with name '" + name + "'");
        }
        this.validateLength(name, newLength);
        this.fieldLengths.set(index2, newLength);
    }

    public void setFieldLength(int position2, int newLength) {
        if (position2 < 0 && position2 >= this.fieldLengths.size()) {
            throw new IllegalArgumentException("No field defined at index " + position2);
        }
        this.validateLength("at index " + position2, newLength);
        this.fieldLengths.set(position2, newLength);
    }
}

