/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.fixed;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.fixed.FixedWidthFormat;
import com.univocity.parsers.fixed.FixedWidthParserSettings;

public class FixedWidthParser
extends AbstractParser<FixedWidthParserSettings> {
    private final int[] lengths;
    private final boolean ignoreLeadingWhitespace;
    private final boolean ignoreTrailingWhitespace;
    private final boolean skipToNewLine;
    private final boolean recordEndsOnNewLine;
    private final boolean skipEmptyLines;
    private final char padding;
    private final char newLine;
    private int length;

    public FixedWidthParser(FixedWidthParserSettings settings2) {
        super(settings2);
        this.ignoreLeadingWhitespace = settings2.getIgnoreLeadingWhitespaces();
        this.ignoreTrailingWhitespace = settings2.getIgnoreTrailingWhitespaces();
        this.skipToNewLine = settings2.getSkipTrailingCharsUntilNewline();
        this.recordEndsOnNewLine = settings2.getRecordEndsOnNewline();
        this.skipEmptyLines = settings2.getSkipEmptyLines();
        this.lengths = settings2.getFieldLengths();
        FixedWidthFormat format2 = (FixedWidthFormat)settings2.getFormat();
        this.padding = format2.getPadding();
        this.newLine = format2.getNormalizedNewline();
    }

    @Override
    protected void parseRecord() {
        if (this.ch == this.newLine && this.skipEmptyLines) {
            return;
        }
        for (int i = 0; i < this.lengths.length; ++i) {
            this.length = this.lengths[i];
            this.skipPadding();
            if (this.ignoreLeadingWhitespace) {
                this.skipWhitespace();
            }
            if (this.recordEndsOnNewLine) {
                this.readValueUntilNewLine();
                if (this.ch == this.newLine) {
                    this.output.valueParsed();
                    return;
                }
            } else {
                this.readValue();
            }
            this.output.valueParsed();
        }
        if (this.skipToNewLine) {
            this.skipToNewLine();
        }
    }

    private void skipToNewLine() {
        while (this.ch != this.newLine) {
            this.ch = this.input.nextChar();
        }
    }

    private void skipPadding() {
        while (this.ch == this.padding && this.length-- > 0) {
            this.ch = this.input.nextChar();
        }
    }

    private void skipWhitespace() {
        while (this.ch <= ' ' && this.length-- > 0) {
            this.ch = this.input.nextChar();
        }
    }

    private void readValueUntilNewLine() {
        if (this.ignoreTrailingWhitespace) {
            while (this.length-- > 0 && this.ch != this.newLine) {
                this.output.appender.appendIgnoringWhitespaceAndPadding(this.ch);
                this.ch = this.input.nextChar();
            }
        } else {
            while (this.length-- > 0 && this.ch != this.newLine) {
                this.output.appender.appendIgnoringPadding(this.ch);
                this.ch = this.input.nextChar();
            }
        }
    }

    private void readValue() {
        if (this.ignoreTrailingWhitespace) {
            while (this.length-- > 0) {
                this.output.appender.appendIgnoringWhitespaceAndPadding(this.ch);
                this.ch = this.input.nextChar();
            }
        } else {
            while (this.length-- > 0) {
                this.output.appender.appendIgnoringPadding(this.ch);
                this.ch = this.input.nextChar();
            }
        }
    }
}

