/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.tsv;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.tsv.TsvFormat;
import com.univocity.parsers.tsv.TsvParserSettings;

public class TsvParser
extends AbstractParser<TsvParserSettings> {
    private final boolean ignoreTrailingWhitespace;
    private final boolean ignoreLeadingWhitespace;
    private final char newLine;
    private final char escapeChar;

    public TsvParser(TsvParserSettings settings2) {
        super(settings2);
        this.ignoreTrailingWhitespace = settings2.getIgnoreTrailingWhitespaces();
        this.ignoreLeadingWhitespace = settings2.getIgnoreLeadingWhitespaces();
        TsvFormat format2 = (TsvFormat)settings2.getFormat();
        this.newLine = format2.getNormalizedNewline();
        this.escapeChar = ((TsvFormat)settings2.getFormat()).getEscapeChar();
    }

    @Override
    protected void parseRecord() {
        if (this.ignoreLeadingWhitespace && this.ch != '\t' && this.ch <= ' ') {
            this.skipWhitespace();
        }
        while (this.ch != this.newLine) {
            this.parseField();
            if (this.ch == this.newLine) continue;
            this.ch = this.input.nextChar();
            if (this.ch != this.newLine) continue;
            this.output.emptyParsed();
        }
    }

    private void parseField() {
        if (this.ignoreLeadingWhitespace && this.ch != '\t' && this.ch <= ' ') {
            this.skipWhitespace();
        }
        if (this.ch == '\t') {
            this.output.emptyParsed();
        } else {
            if (this.ignoreTrailingWhitespace) {
                while (this.ch != '\t' && this.ch != this.newLine) {
                    if (this.ch == this.escapeChar) {
                        this.ch = this.input.nextChar();
                        if (this.ch == 't') {
                            this.output.appender.appendIgnoringWhitespace('\t');
                        } else if (this.ch == 'n') {
                            this.output.appender.appendIgnoringWhitespace('\n');
                        } else if (this.ch == '\\') {
                            this.output.appender.appendIgnoringWhitespace('\\');
                        } else if (this.ch == 'r') {
                            this.output.appender.appendIgnoringWhitespace('\r');
                        } else {
                            this.output.appender.append(this.escapeChar);
                            if (this.ch == this.newLine || this.ch == '\t') break;
                            this.output.appender.appendIgnoringWhitespace(this.ch);
                        }
                        this.ch = this.input.nextChar();
                        continue;
                    }
                    this.output.appender.appendIgnoringWhitespace(this.ch);
                    this.ch = this.input.nextChar();
                }
            } else {
                while (this.ch != '\t' && this.ch != this.newLine) {
                    if (this.ch == this.escapeChar) {
                        this.ch = this.input.nextChar();
                        if (this.ch == 't') {
                            this.output.appender.append('\t');
                        } else if (this.ch == 'n') {
                            this.output.appender.append('\n');
                        } else if (this.ch == '\\') {
                            this.output.appender.append('\\');
                        } else if (this.ch == 'r') {
                            this.output.appender.append('\r');
                        } else {
                            this.output.appender.append(this.escapeChar);
                            if (this.ch == this.newLine || this.ch == '\t') break;
                            this.output.appender.append(this.ch);
                        }
                        this.ch = this.input.nextChar();
                        continue;
                    }
                    this.output.appender.append(this.ch);
                    this.ch = this.input.nextChar();
                }
            }
            this.output.valueParsed();
        }
    }

    private void skipWhitespace() {
        while (this.ch != '\t' && this.ch <= ' ' && this.ch != this.newLine) {
            this.ch = this.input.nextChar();
        }
    }
}

