/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.api.RequestKeys$;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadataRequest$;
import kafka.api.TopicMetadataResponse;
import kafka.common.ErrorMapping$;
import kafka.network.BoundedByteBufferSend;
import kafka.network.RequestChannel;
import scala.Product;
import scala.Product$class;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005ux!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006+pa&\u001cW*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051B\u0001\u000bU_BL7-T3uC\u0012\fG/\u0019*fcV,7\u000f^\n\u0005\u00131\u0011\u0002\u0004\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\tQ!\u001e;jYNL!a\u0006\u000b\u0003\u000f1{wmZ5oOB\u0011Q\"G\u0005\u000359\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001H\u0005\u0005\u0002u\ta\u0001P5oSRtD#A\u0004\t\u000f}I!\u0019!C\u0001A\u0005q1)\u001e:sK:$h+\u001a:tS>tW#A\u0011\u0011\u00055\u0011\u0013BA\u0012\u000f\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0019)\u0013\u0002)A\u0005C\u0005y1)\u001e:sK:$h+\u001a:tS>t\u0007\u0005C\u0004(\u0013\t\u0007I\u0011\u0001\u0015\u0002\u001f\u0011+g-Y;mi\u000ec\u0017.\u001a8u\u0013\u0012,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\"1!'\u0003Q\u0001\n%\n\u0001\u0003R3gCVdGo\u00117jK:$\u0018\n\u001a\u0011\t\u000bQJA\u0011A\u001b\u0002\u0011I,\u0017\r\u001a$s_6$2ANAf!\tAqG\u0002\u0003\u000b\u0005\u0001C4\u0003B\u001c:ya\u0001\"\u0001\u0003\u001e\n\u0005m\u0012!!\u0005*fcV,7\u000f^(s%\u0016\u001c\bo\u001c8tKB\u0011Q\"P\u0005\u0003}9\u0011q\u0001\u0015:pIV\u001cG\u000f\u0003\u0005Ao\tU\r\u0011\"\u0001!\u0003%1XM]:j_:LE\r\u0003\u0005Co\tE\t\u0015!\u0003\"\u0003)1XM]:j_:LE\r\t\u0005\t\t^\u0012)\u001a!C\u0001\u000b\u0006i1m\u001c:sK2\fG/[8o\u0013\u0012,\u0012A\u0012\t\u0003\u001b\u001dK!\u0001\u0013\b\u0003\u0007%sG\u000f\u0003\u0005Ko\tE\t\u0015!\u0003G\u00039\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI\u0002B\u0001\u0002T\u001c\u0003\u0016\u0004%\t!T\u0001\tG2LWM\u001c;JIV\ta\n\u0005\u0002P%:\u0011Q\u0002U\u0005\u0003#:\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0019T\u0015\t\tf\u0002\u0003\u0005Vo\tE\t\u0015!\u0003O\u0003%\u0019G.[3oi&#\u0007\u0005\u0003\u0005Xo\tU\r\u0011\"\u0001Y\u0003\u0019!x\u000e]5dgV\t\u0011\fE\u0002[E:s!a\u00171\u000f\u0005q{V\"A/\u000b\u0005y3\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\t\tg\"A\u0004qC\u000e\\\u0017mZ3\n\u0005\r$'aA*fc*\u0011\u0011M\u0004\u0005\tM^\u0012\t\u0012)A\u00053\u00069Ao\u001c9jGN\u0004\u0003\"\u0002\u000f8\t\u0003AG#\u0002\u001cjU.d\u0007\"\u0002!h\u0001\u0004\t\u0003\"\u0002#h\u0001\u00041\u0005\"\u0002'h\u0001\u0004q\u0005\"B,h\u0001\u0004I\u0006\"\u0002\u000f8\t\u0003qGc\u0001\u001cpa\")q+\u001ca\u00013\")A)\u001ca\u0001\r\")!o\u000eC\u0001g\u00069qO]5uKR{GC\u0001;x!\tiQ/\u0003\u0002w\u001d\t!QK\\5u\u0011\u0015A\u0018\u000f1\u0001z\u0003\u0019\u0011WO\u001a4feB\u0011!0`\u0007\u0002w*\u0011A0L\u0001\u0004]&|\u0017B\u0001@|\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0003\u00039D\u0011AA\u0002\u0003-\u0019\u0018N_3J]\nKH/Z:\u0015\u0003\u0019Cq!a\u00028\t\u0003\nI!\u0001\u0005u_N#(/\u001b8h)\u0005q\u0005bBA\u0007o\u0011\u0005\u0013qB\u0001\fQ\u0006tG\r\\3FeJ|'\u000fF\u0004u\u0003#\tY\"a\u000b\t\u0011\u0005M\u00111\u0002a\u0001\u0003+\t\u0011!\u001a\t\u00045\u0006]\u0011bAA\rI\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\t\u0003;\tY\u00011\u0001\u0002 \u0005q!/Z9vKN$8\t[1o]\u0016d\u0007\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015B!A\u0004oKR<xN]6\n\t\u0005%\u00121\u0005\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0011!\ti#a\u0003A\u0002\u0005=\u0012a\u0002:fcV,7\u000f\u001e\t\u0005\u0003c\t9D\u0004\u0003\u0002\"\u0005M\u0012\u0002BA\u001b\u0003G\taBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0003\u0002:\u0005m\"a\u0002*fcV,7\u000f\u001e\u0006\u0005\u0003k\t\u0019\u0003C\u0004\u0002@]\"\t%!\u0011\u0002\u0011\u0011,7o\u0019:jE\u0016$2ATA\"\u0011!\t)%!\u0010A\u0002\u0005\u001d\u0013a\u00023fi\u0006LGn\u001d\t\u0004\u001b\u0005%\u0013bAA&\u001d\t9!i\\8mK\u0006t\u0007\"CA(o\u0005\u0005I\u0011AA)\u0003\u0011\u0019w\u000e]=\u0015\u0013Y\n\u0019&!\u0016\u0002X\u0005e\u0003\u0002\u0003!\u0002NA\u0005\t\u0019A\u0011\t\u0011\u0011\u000bi\u0005%AA\u0002\u0019C\u0001\u0002TA'!\u0003\u0005\rA\u0014\u0005\t/\u00065\u0003\u0013!a\u00013\"I\u0011QL\u001c\u0012\u0002\u0013\u0005\u0011qL\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tGK\u0002\"\u0003GZ#!!\u001a\u0011\t\u0005\u001d\u0014\u0011O\u0007\u0003\u0003SRA!a\u001b\u0002n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003_r\u0011AC1o]>$\u0018\r^5p]&!\u00111OA5\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003o:\u0014\u0013!C\u0001\u0003s\nabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002|)\u001aa)a\u0019\t\u0013\u0005}t'%A\u0005\u0002\u0005\u0005\u0015AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0007S3ATA2\u0011%\t9iNI\u0001\n\u0003\tI)\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005-%fA-\u0002d!A\u0011qR\u001c\u0002\u0002\u0013\u0005\u0003&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e\u001f\u0005\t\u0003';\u0014\u0011!C\u0001\u000b\u0006a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011qS\u001c\u0002\u0002\u0013\u0005\u0011\u0011T\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY*!)\u0011\u00075\ti*C\u0002\u0002 :\u00111!\u00118z\u0011%\t\u0019+!&\u0002\u0002\u0003\u0007a)A\u0002yIEB\u0011\"a*8\u0003\u0003%\t%!+\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a+\u0011\r\u00055\u00161WAN\u001b\t\tyKC\u0002\u00022:\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t),a,\u0003\u0011%#XM]1u_JD\u0011\"!/8\u0003\u0003%\t!a/\u0002\u0011\r\fg.R9vC2$B!a\u0012\u0002>\"Q\u00111UA\\\u0003\u0003\u0005\r!a'\t\u0013\u0005\u0005w'!A\u0005B\u0005\r\u0011\u0001\u00035bg\"\u001cu\u000eZ3\t\u0013\u0005\u0015w'!A\u0005B\u0005\u001d\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002H\u0005%\u0007BCAR\u0003\u0007\f\t\u00111\u0001\u0002\u001c\")\u0001p\ra\u0001s\"I\u0011qZ\u0005\u0002\u0002\u0013\u0005\u0015\u0011[\u0001\u0006CB\u0004H.\u001f\u000b\nm\u0005M\u0017Q[Al\u00033Da\u0001QAg\u0001\u0004\t\u0003B\u0002#\u0002N\u0002\u0007a\t\u0003\u0004M\u0003\u001b\u0004\rA\u0014\u0005\u0007/\u00065\u0007\u0019A-\t\u0013\u0005u\u0017\"!A\u0005\u0002\u0006}\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0003C\fi\u000fE\u0003\u000e\u0003G\f9/C\u0002\u0002f:\u0011aa\u00149uS>t\u0007cB\u0007\u0002j\u00062e*W\u0005\u0004\u0003Wt!A\u0002+va2,G\u0007C\u0005\u0002p\u0006m\u0017\u0011!a\u0001m\u0005\u0019\u0001\u0010\n\u0019\t\u0013\u0005M\u0018\"!A\u0005\n\u0005U\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a>\u0011\u0007)\nI0C\u0002\u0002|.\u0012aa\u00142kK\u000e$\b")
public class TopicMetadataRequest
extends RequestOrResponse
implements Product,
scala.Serializable {
    private final short versionId;
    private final int correlationId;
    private final String clientId;
    private final Seq<String> topics;

    public static TopicMetadataRequest readFrom(ByteBuffer byteBuffer) {
        return TopicMetadataRequest$.MODULE$.readFrom(byteBuffer);
    }

    public static String DefaultClientId() {
        return TopicMetadataRequest$.MODULE$.DefaultClientId();
    }

    public static short CurrentVersion() {
        return TopicMetadataRequest$.MODULE$.CurrentVersion();
    }

    public short versionId() {
        return this.versionId;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public Seq<String> topics() {
        return this.topics;
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        buffer.putShort(this.versionId());
        buffer.putInt(this.correlationId());
        ApiUtils$.MODULE$.writeShortString(buffer, this.clientId());
        buffer.putInt(this.topics().size());
        this.topics().foreach(new scala.Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$2;

            public final void apply(String topic) {
                ApiUtils$.MODULE$.writeShortString(this.buffer$2, topic);
            }
            {
                this.buffer$2 = buffer$2;
            }
        });
    }

    @Override
    public int sizeInBytes() {
        return 6 + ApiUtils$.MODULE$.shortStringLength(this.clientId()) + 4 + BoxesRunTime.unboxToInt(this.topics().foldLeft(BoxesRunTime.boxToInteger(0), new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$1, String x$2) {
                return x$1 + ApiUtils$.MODULE$.shortStringLength(x$2);
            }
        }));
    }

    public String toString() {
        return this.describe(true);
    }

    @Override
    public void handleError(Throwable e, RequestChannel requestChannel, RequestChannel.Request request) {
        Seq<TopicMetadata> topicMetadata = this.topics().map(new scala.Serializable(this, e){
            public static final long serialVersionUID = 0L;
            private final Throwable e$1;

            public final TopicMetadata apply(String topic) {
                return new TopicMetadata(topic, Nil$.MODULE$, ErrorMapping$.MODULE$.codeFor(this.e$1.getClass()));
            }
            {
                this.e$1 = e$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        TopicMetadataResponse errorResponse = new TopicMetadataResponse((Seq)Seq$.MODULE$.apply(Nil$.MODULE$), topicMetadata, this.correlationId());
        requestChannel.sendResponse(new RequestChannel.Response(request, new BoundedByteBufferSend(errorResponse)));
    }

    @Override
    public String describe(boolean details) {
        StringBuilder topicMetadataRequest = new StringBuilder();
        topicMetadataRequest.append(new StringBuilder().append((Object)"Name: ").append((Object)this.getClass().getSimpleName()).toString());
        topicMetadataRequest.append(new StringBuilder().append((Object)"; Version: ").append(BoxesRunTime.boxToShort(this.versionId())).toString());
        topicMetadataRequest.append(new StringBuilder().append((Object)"; CorrelationId: ").append(BoxesRunTime.boxToInteger(this.correlationId())).toString());
        topicMetadataRequest.append(new StringBuilder().append((Object)"; ClientId: ").append((Object)this.clientId()).toString());
        Serializable serializable2 = details ? topicMetadataRequest.append(new StringBuilder().append((Object)"; Topics: ").append((Object)this.topics().mkString(",")).toString()) : BoxedUnit.UNIT;
        return topicMetadataRequest.toString();
    }

    public TopicMetadataRequest copy(short versionId, int correlationId, String clientId, Seq<String> topics) {
        return new TopicMetadataRequest(versionId, correlationId, clientId, topics);
    }

    public short copy$default$1() {
        return this.versionId();
    }

    public int copy$default$2() {
        return this.correlationId();
    }

    public String copy$default$3() {
        return this.clientId();
    }

    public Seq<String> copy$default$4() {
        return this.topics();
    }

    @Override
    public String productPrefix() {
        return "TopicMetadataRequest";
    }

    @Override
    public int productArity() {
        return 4;
    }

    @Override
    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
            case 3: {
                object = this.topics();
                break;
            }
            case 2: {
                object = this.clientId();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger(this.correlationId());
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToShort(this.versionId());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof TopicMetadataRequest;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.versionId());
        n = Statics.mix(n, this.correlationId());
        n = Statics.mix(n, Statics.anyHash(this.clientId()));
        n = Statics.mix(n, Statics.anyHash(this.topics()));
        return Statics.finalizeHash(n, 4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TopicMetadataRequest)) return false;
        boolean bl = true;
        if (!bl) return false;
        TopicMetadataRequest topicMetadataRequest = (TopicMetadataRequest)x$1;
        if (this.versionId() != topicMetadataRequest.versionId()) return false;
        if (this.correlationId() != topicMetadataRequest.correlationId()) return false;
        String string2 = this.clientId();
        String string3 = topicMetadataRequest.clientId();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        Seq<String> seq2 = this.topics();
        Seq<String> seq3 = topicMetadataRequest.topics();
        if (seq2 == null) {
            if (seq3 != null) {
                return false;
            }
        } else if (!seq2.equals(seq3)) return false;
        if (!topicMetadataRequest.canEqual(this)) return false;
        return true;
    }

    public TopicMetadataRequest(short versionId, int correlationId, String clientId, Seq<String> topics) {
        this.versionId = versionId;
        this.correlationId = correlationId;
        this.clientId = clientId;
        this.topics = topics;
        super(new Some<Object>(BoxesRunTime.boxToShort(RequestKeys$.MODULE$.MetadataKey())));
        Product$class.$init$(this);
    }

    public TopicMetadataRequest(Seq<String> topics, int correlationId) {
        this(TopicMetadataRequest$.MODULE$.CurrentVersion(), correlationId, TopicMetadataRequest$.MODULE$.DefaultClientId(), topics);
    }
}

