/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.consumer.ConsumerTopicStatsRegistry$;
import kafka.consumer.FetchRequestAndResponseStatsRegistry$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.producer.ProducerRequestStatsRegistry$;
import kafka.producer.ProducerStatsRegistry$;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class KafkaMetricsGroup$
implements KafkaMetricsGroup {
    public static final KafkaMetricsGroup$ MODULE$;
    private final List<MetricName> consumerMetricNameList;
    private final List<MetricName> producerMetricNameList;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new KafkaMetricsGroup$();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaMetricsGroup$ kafkaMetricsGroup$ = this;
        synchronized (kafkaMetricsGroup$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action2) {
        Logging$class.swallowTrace(this, action2);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action2) {
        Logging$class.swallowDebug(this, action2);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action2) {
        Logging$class.swallowInfo(this, action2);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action2) {
        Logging$class.swallowWarn(this, action2);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action2) {
        Logging$class.swallow(this, action2);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action2) {
        Logging$class.swallowError(this, action2);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private List<MetricName> consumerMetricNameList() {
        return this.consumerMetricNameList;
    }

    private List<MetricName> producerMetricNameList() {
        return this.producerMetricNameList;
    }

    public Option<String> kafka$metrics$KafkaMetricsGroup$$toMBeanName(Map<String, String> tags) {
        Option option;
        Map filteredTags = (Map)tags.filter((Function1<String, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String tagValue;
                    String string2 = tagValue = tuple2._2();
                    String string3 = "";
                    boolean bl = string2 != null ? !string2.equals(string3) : string3 != null;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }));
        if (filteredTags.nonEmpty()) {
            String tagsString = ((TraversableOnce)filteredTags.map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, String> x0$2) {
                    Tuple2<String, String> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String key = tuple2._1();
                        String value2 = tuple2._2();
                        String string2 = new StringOps(Predef$.MODULE$.augmentString("%s=%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{key, value2}));
                        return string2;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
            option = new Some<String>(tagsString);
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public Option<String> kafka$metrics$KafkaMetricsGroup$$toScope(Map<String, String> tags) {
        Option option;
        Map filteredTags = (Map)tags.filter((Function1<String, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String tagValue;
                    String string2 = tagValue = tuple2._2();
                    String string3 = "";
                    boolean bl = string2 != null ? !string2.equals(string3) : string3 != null;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }));
        if (filteredTags.nonEmpty()) {
            String tagsString = ((TraversableOnce)((TraversableLike)filteredTags.toList().sortWith((Function2<Tuple2<String, String>, Tuple2<String, String>, Object>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> t1, Tuple2<String, String> t2) {
                    return new StringOps(Predef$.MODULE$.augmentString(t1._1())).$less(t2._1());
                }
            }))).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, String> x0$4) {
                    Tuple2<String, String> tuple2 = x0$4;
                    if (tuple2 != null) {
                        String key = tuple2._1();
                        String value2 = tuple2._2();
                        String string2 = new StringOps(Predef$.MODULE$.augmentString("%s.%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{key, value2.replaceAll("\\.", "_")}));
                        return string2;
                    }
                    throw new MatchError(tuple2);
                }
            }, List$.MODULE$.canBuildFrom())).mkString(".");
            option = new Some<String>(tagsString);
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public void removeAllConsumerMetrics(String clientId) {
        FetchRequestAndResponseStatsRegistry$.MODULE$.removeConsumerFetchRequestAndResponseStats(clientId);
        ConsumerTopicStatsRegistry$.MODULE$.removeConsumerTopicStat(clientId);
        ProducerRequestStatsRegistry$.MODULE$.removeProducerRequestStats(clientId);
        this.removeAllMetricsInList(this.consumerMetricNameList(), clientId);
    }

    public void removeAllProducerMetrics(String clientId) {
        ProducerRequestStatsRegistry$.MODULE$.removeProducerRequestStats(clientId);
        ProducerTopicStatsRegistry$.MODULE$.removeProducerTopicStats(clientId);
        ProducerStatsRegistry$.MODULE$.removeProducerStats(clientId);
        this.removeAllMetricsInList(this.producerMetricNameList(), clientId);
    }

    private void removeAllMetricsInList(List<MetricName> metricNameList, String clientId) {
        metricNameList.foreach(new Serializable(clientId){
            public static final long serialVersionUID = 0L;
            private final String clientId$1;

            public final void apply(MetricName metric) {
                Regex pattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)".*clientId=").append((Object)this.clientId$1).append((Object)".*").toString())).r();
                Set<MetricName> registeredMetrics = JavaConversions$.MODULE$.asScalaSet(Metrics.defaultRegistry().allMetrics().keySet());
                registeredMetrics.foreach(new Serializable(this, metric, pattern){
                    public static final long serialVersionUID = 0L;
                    private final MetricName metric$1;
                    private final Regex pattern$1;

                    public final void apply(MetricName registeredMetric) {
                        String string2 = registeredMetric.getGroup();
                        String string3 = this.metric$1.getGroup();
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            String string4 = registeredMetric.getName();
                            String string5 = this.metric$1.getName();
                            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                                String string6 = registeredMetric.getType();
                                String string7 = this.metric$1.getType();
                                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                    Option<String> option = this.pattern$1.findFirstIn(registeredMetric.getMBeanName());
                                    if (option instanceof Some) {
                                        int beforeRemovalSize = Metrics.defaultRegistry().allMetrics().keySet().size();
                                        Metrics.defaultRegistry().removeMetric(registeredMetric);
                                        int afterRemovalSize = Metrics.defaultRegistry().allMetrics().keySet().size();
                                        KafkaMetricsGroup$.MODULE$.trace((Function0<String>)((Object)new Serializable(this, registeredMetric, beforeRemovalSize, afterRemovalSize){
                                            public static final long serialVersionUID = 0L;
                                            private final MetricName registeredMetric$1;
                                            private final int beforeRemovalSize$1;
                                            private final int afterRemovalSize$1;

                                            public final String apply() {
                                                return new StringOps(Predef$.MODULE$.augmentString("Removing metric %s. Metrics registry size reduced from %d to %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.registeredMetric$1, BoxesRunTime.boxToInteger(this.beforeRemovalSize$1), BoxesRunTime.boxToInteger(this.afterRemovalSize$1)}));
                                            }
                                            {
                                                this.registeredMetric$1 = registeredMetric$1;
                                                this.beforeRemovalSize$1 = beforeRemovalSize$1;
                                                this.afterRemovalSize$1 = afterRemovalSize$1;
                                            }
                                        }));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                }
                            }
                        }
                    }
                    {
                        this.metric$1 = metric$1;
                        this.pattern$1 = pattern$1;
                    }
                });
            }
            {
                this.clientId$1 = clientId$1;
            }
        });
    }

    private KafkaMetricsGroup$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.consumerMetricNameList = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new MetricName[]{new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "FetchQueueSize"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "KafkaCommitsPerSec"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "ZooKeeperCommitsPerSec"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "RebalanceRateAndTime"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "OwnedPartitionsCount"), new MetricName("kafka.consumer", "ConsumerFetcherManager", "MaxLag"), new MetricName("kafka.consumer", "ConsumerFetcherManager", "MinFetchRate"), new MetricName("kafka.server", "FetcherLagMetrics", "ConsumerLag"), new MetricName("kafka.consumer", "ConsumerTopicMetrics", "MessagesPerSec"), new MetricName("kafka.consumer", "ConsumerTopicMetrics", "BytesPerSec"), new MetricName("kafka.server", "FetcherStats", "BytesPerSec"), new MetricName("kafka.server", "FetcherStats", "RequestsPerSec"), new MetricName("kafka.consumer", "FetchRequestAndResponseMetrics", "FetchResponseSize"), new MetricName("kafka.consumer", "FetchRequestAndResponseMetrics", "FetchRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestSize")}));
        this.producerMetricNameList = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new MetricName[]{new MetricName("kafka.producer", "ProducerStats", "SerializationErrorsPerSec"), new MetricName("kafka.producer", "ProducerStats", "ResendsPerSec"), new MetricName("kafka.producer", "ProducerStats", "FailedSendsPerSec"), new MetricName("kafka.producer.async", "ProducerSendThread", "ProducerQueueSize"), new MetricName("kafka.producer", "ProducerTopicMetrics", "MessagesPerSec"), new MetricName("kafka.producer", "ProducerTopicMetrics", "DroppedMessagesPerSec"), new MetricName("kafka.producer", "ProducerTopicMetrics", "BytesPerSec"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestSize")}));
    }
}

