/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Constants;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Utils;
import net.jpountz.util.Utils;

final class LZ4JavaSafeCompressor
extends LZ4Compressor {
    public static final LZ4Compressor INSTANCE = new LZ4JavaSafeCompressor();

    LZ4JavaSafeCompressor() {
    }

    static int compress64k(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int destEnd) {
        int srcEnd = srcOff + srcLen;
        int srcLimit = srcEnd - 5;
        int mflimit = srcEnd - 12;
        int sOff = srcOff;
        int dOff = destOff;
        int anchor2 = sOff++;
        if (srcLen >= 13) {
            short[] hashTable = new short[8192];
            block0: while (true) {
                int ref;
                int forwardOff = sOff;
                int findMatchAttempts = (1 << LZ4Constants.SKIP_STRENGTH) + 3;
                do {
                    sOff = forwardOff;
                    if ((forwardOff += findMatchAttempts++ >>> LZ4Constants.SKIP_STRENGTH) > mflimit) break block0;
                    int h = LZ4Utils.hash64k(Utils.readInt(src, sOff));
                    ref = srcOff + Utils.readShort(hashTable, h);
                    Utils.writeShort(hashTable, h, sOff - srcOff);
                } while (!LZ4Utils.readIntEquals(src, ref, sOff));
                int excess = LZ4Utils.commonBytesBackward(src, ref, sOff, srcOff, anchor2);
                ref -= excess;
                int runLen = (sOff -= excess) - anchor2;
                int tokenOff = dOff++;
                if (dOff + runLen + 8 + (runLen >>> 8) > destEnd) {
                    throw new LZ4Exception("maxDestLen is too small");
                }
                if (runLen >= 15) {
                    Utils.writeByte(dest, tokenOff, 240);
                    dOff = LZ4Utils.writeLen(runLen - 15, dest, dOff);
                } else {
                    Utils.writeByte(dest, tokenOff, runLen << 4);
                }
                LZ4Utils.wildArraycopy(src, anchor2, dest, dOff, runLen);
                dOff += runLen;
                while (true) {
                    Utils.writeShortLittleEndian(dest, dOff, (short)(sOff - ref));
                    int matchLen = LZ4Utils.commonBytes(src, ref += 4, sOff += 4, srcLimit);
                    if ((dOff += 2) + 6 + (matchLen >>> 8) > destEnd) {
                        throw new LZ4Exception("maxDestLen is too small");
                    }
                    sOff += matchLen;
                    if (matchLen >= 15) {
                        Utils.writeByte(dest, tokenOff, Utils.readByte(dest, tokenOff) | 0xF);
                        dOff = LZ4Utils.writeLen(matchLen - 15, dest, dOff);
                    } else {
                        Utils.writeByte(dest, tokenOff, Utils.readByte(dest, tokenOff) | matchLen);
                    }
                    if (sOff > mflimit) {
                        anchor2 = sOff;
                        break block0;
                    }
                    Utils.writeShort(hashTable, LZ4Utils.hash64k(Utils.readInt(src, sOff - 2)), sOff - 2 - srcOff);
                    int h = LZ4Utils.hash64k(Utils.readInt(src, sOff));
                    ref = srcOff + Utils.readShort(hashTable, h);
                    Utils.writeShort(hashTable, h, sOff - srcOff);
                    if (!LZ4Utils.readIntEquals(src, sOff, ref)) break;
                    tokenOff = dOff++;
                    dest[tokenOff] = 0;
                }
                anchor2 = sOff++;
            }
        }
        dOff = LZ4Utils.lastLiterals(src, anchor2, srcEnd - anchor2, dest, dOff, destEnd);
        return dOff - destOff;
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int maxDestLen) {
        Utils.checkRange(src, srcOff, srcLen);
        Utils.checkRange(dest, destOff, maxDestLen);
        int destEnd = destOff + maxDestLen;
        if (srcLen < 65547) {
            return LZ4JavaSafeCompressor.compress64k(src, srcOff, srcLen, dest, destOff, destEnd);
        }
        int srcEnd = srcOff + srcLen;
        int srcLimit = srcEnd - 5;
        int mflimit = srcEnd - 12;
        int sOff = srcOff;
        int dOff = destOff;
        int anchor2 = sOff++;
        int[] hashTable = new int[4096];
        Arrays.fill(hashTable, anchor2);
        block0: while (true) {
            int ref;
            int back;
            int forwardOff = sOff;
            int findMatchAttempts = (1 << LZ4Constants.SKIP_STRENGTH) + 3;
            do {
                sOff = forwardOff;
                if ((forwardOff += findMatchAttempts++ >>> LZ4Constants.SKIP_STRENGTH) > mflimit) break block0;
                int h = LZ4Utils.hash(Utils.readInt(src, sOff));
                ref = Utils.readInt(hashTable, h);
                back = sOff - ref;
                Utils.writeInt(hashTable, h, sOff);
            } while (back >= 65536 || !LZ4Utils.readIntEquals(src, ref, sOff));
            int excess = LZ4Utils.commonBytesBackward(src, ref, sOff, srcOff, anchor2);
            ref -= excess;
            int runLen = (sOff -= excess) - anchor2;
            int tokenOff = dOff++;
            if (dOff + runLen + 8 + (runLen >>> 8) > destEnd) {
                throw new LZ4Exception("maxDestLen is too small");
            }
            if (runLen >= 15) {
                Utils.writeByte(dest, tokenOff, 240);
                dOff = LZ4Utils.writeLen(runLen - 15, dest, dOff);
            } else {
                Utils.writeByte(dest, tokenOff, runLen << 4);
            }
            LZ4Utils.wildArraycopy(src, anchor2, dest, dOff, runLen);
            dOff += runLen;
            while (true) {
                Utils.writeShortLittleEndian(dest, dOff, back);
                int matchLen = LZ4Utils.commonBytes(src, ref + 4, sOff += 4, srcLimit);
                if ((dOff += 2) + 6 + (matchLen >>> 8) > destEnd) {
                    throw new LZ4Exception("maxDestLen is too small");
                }
                sOff += matchLen;
                if (matchLen >= 15) {
                    Utils.writeByte(dest, tokenOff, Utils.readByte(dest, tokenOff) | 0xF);
                    dOff = LZ4Utils.writeLen(matchLen - 15, dest, dOff);
                } else {
                    Utils.writeByte(dest, tokenOff, Utils.readByte(dest, tokenOff) | matchLen);
                }
                if (sOff > mflimit) {
                    anchor2 = sOff;
                    break block0;
                }
                Utils.writeInt(hashTable, LZ4Utils.hash(Utils.readInt(src, sOff - 2)), sOff - 2);
                int h = LZ4Utils.hash(Utils.readInt(src, sOff));
                ref = Utils.readInt(hashTable, h);
                Utils.writeInt(hashTable, h, sOff);
                back = sOff - ref;
                if (back >= 65536 || !LZ4Utils.readIntEquals(src, ref, sOff)) break;
                tokenOff = dOff++;
                Utils.writeByte(dest, tokenOff, 0);
            }
            anchor2 = sOff++;
        }
        dOff = LZ4Utils.lastLiterals(src, anchor2, srcEnd - anchor2, dest, dOff, destEnd);
        return dOff - destOff;
    }
}

