/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.csv.Assertions;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.ExtendedBufferedReader;
import org.apache.commons.csv.Lexer;
import org.apache.commons.csv.Token;

public final class CSVParser
implements Iterable<CSVRecord>,
Closeable {
    private final CSVFormat format;
    private final Map<String, Integer> headerMap;
    private final Lexer lexer;
    private final List<String> record = new ArrayList<String>();
    private long recordNumber;
    private final long characterOffset;
    private final Token reusableToken = new Token();

    public static CSVParser parse(File file, Charset charset, CSVFormat format2) throws IOException {
        Assertions.notNull(file, "file");
        Assertions.notNull(format2, "format");
        return new CSVParser(new InputStreamReader((InputStream)new FileInputStream(file), charset), format2);
    }

    public static CSVParser parse(String string2, CSVFormat format2) throws IOException {
        Assertions.notNull(string2, "string");
        Assertions.notNull(format2, "format");
        return new CSVParser(new StringReader(string2), format2);
    }

    public static CSVParser parse(URL url, Charset charset, CSVFormat format2) throws IOException {
        Assertions.notNull(url, "url");
        Assertions.notNull(charset, "charset");
        Assertions.notNull(format2, "format");
        return new CSVParser(new InputStreamReader(url.openStream(), charset), format2);
    }

    public CSVParser(Reader reader, CSVFormat format2) throws IOException {
        this(reader, format2, 0L, 1L);
    }

    public CSVParser(Reader reader, CSVFormat format2, long characterOffset, long recordNumber) throws IOException {
        Assertions.notNull(reader, "reader");
        Assertions.notNull(format2, "format");
        this.format = format2;
        this.lexer = new Lexer(format2, new ExtendedBufferedReader(reader));
        this.headerMap = this.initializeHeader();
        this.characterOffset = characterOffset;
        this.recordNumber = recordNumber - 1L;
    }

    private void addRecordValue() {
        String input2 = this.reusableToken.content.toString();
        String nullString = this.format.getNullString();
        if (nullString == null) {
            this.record.add(input2);
        } else {
            this.record.add(input2.equalsIgnoreCase(nullString) ? null : input2);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.lexer != null) {
            this.lexer.close();
        }
    }

    public long getCurrentLineNumber() {
        return this.lexer.getCurrentLineNumber();
    }

    public Map<String, Integer> getHeaderMap() {
        return this.headerMap == null ? null : new LinkedHashMap<String, Integer>(this.headerMap);
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public List<CSVRecord> getRecords() throws IOException {
        CSVRecord rec;
        ArrayList<CSVRecord> records = new ArrayList<CSVRecord>();
        while ((rec = this.nextRecord()) != null) {
            records.add(rec);
        }
        return records;
    }

    private Map<String, Integer> initializeHeader() throws IOException {
        LinkedHashMap<String, Integer> hdrMap = null;
        Object[] formatHeader = this.format.getHeader();
        if (formatHeader != null) {
            hdrMap = new LinkedHashMap<String, Integer>();
            Object[] headerRecord = null;
            if (formatHeader.length == 0) {
                CSVRecord nextRecord = this.nextRecord();
                if (nextRecord != null) {
                    headerRecord = nextRecord.values();
                }
            } else {
                if (this.format.getSkipHeaderRecord()) {
                    this.nextRecord();
                }
                headerRecord = formatHeader;
            }
            if (headerRecord != null) {
                for (int i = 0; i < headerRecord.length; ++i) {
                    boolean emptyHeader;
                    String header = headerRecord[i];
                    boolean containsHeader = hdrMap.containsKey(header);
                    boolean bl = emptyHeader = header == null || header.trim().isEmpty();
                    if (containsHeader && (!emptyHeader || emptyHeader && !this.format.getAllowMissingColumnNames())) {
                        throw new IllegalArgumentException("The header contains a duplicate name: \"" + header + "\" in " + Arrays.toString(headerRecord));
                    }
                    hdrMap.put(header, i);
                }
            }
        }
        return hdrMap;
    }

    public boolean isClosed() {
        return this.lexer.isClosed();
    }

    @Override
    public Iterator<CSVRecord> iterator() {
        return new Iterator<CSVRecord>(){
            private CSVRecord current;

            private CSVRecord getNextRecord() {
                try {
                    return CSVParser.this.nextRecord();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean hasNext() {
                if (CSVParser.this.isClosed()) {
                    return false;
                }
                if (this.current == null) {
                    this.current = this.getNextRecord();
                }
                return this.current != null;
            }

            @Override
            public CSVRecord next() {
                if (CSVParser.this.isClosed()) {
                    throw new NoSuchElementException("CSVParser has been closed");
                }
                CSVRecord next2 = this.current;
                this.current = null;
                if (next2 == null && (next2 = this.getNextRecord()) == null) {
                    throw new NoSuchElementException("No more CSV records available");
                }
                return next2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    CSVRecord nextRecord() throws IOException {
        CSVRecord result2 = null;
        this.record.clear();
        StringBuilder sb = null;
        long startCharPosition = this.lexer.getCharacterPosition() + this.characterOffset;
        block7: do {
            this.reusableToken.reset();
            this.lexer.nextToken(this.reusableToken);
            switch (this.reusableToken.type) {
                case TOKEN: {
                    this.addRecordValue();
                    break;
                }
                case EORECORD: {
                    this.addRecordValue();
                    break;
                }
                case EOF: {
                    if (!this.reusableToken.isReady) continue block7;
                    this.addRecordValue();
                    break;
                }
                case INVALID: {
                    throw new IOException("(line " + this.getCurrentLineNumber() + ") invalid parse sequence");
                }
                case COMMENT: {
                    if (sb == null) {
                        sb = new StringBuilder();
                    } else {
                        sb.append('\n');
                    }
                    sb.append((CharSequence)this.reusableToken.content);
                    this.reusableToken.type = Token.Type.TOKEN;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected Token type: " + (Object)((Object)this.reusableToken.type));
                }
            }
        } while (this.reusableToken.type == Token.Type.TOKEN);
        if (!this.record.isEmpty()) {
            ++this.recordNumber;
            String comment2 = sb == null ? null : sb.toString();
            result2 = new CSVRecord(this.record.toArray(new String[this.record.size()]), this.headerMap, comment2, this.recordNumber, startCharPosition);
        }
        return result2;
    }
}

