/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.csv.Assertions;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;

public final class CSVPrinter
implements Flushable,
Closeable {
    private final Appendable out;
    private final CSVFormat format;
    private boolean newRecord = true;

    public CSVPrinter(Appendable out, CSVFormat format2) throws IOException {
        Assertions.notNull(out, "out");
        Assertions.notNull(format2, "format");
        this.out = out;
        this.format = format2;
        if (format2.getHeaderComments() != null) {
            for (String line : format2.getHeaderComments()) {
                if (line == null) continue;
                this.printComment(line);
            }
        }
        if (format2.getHeader() != null) {
            this.printRecord(format2.getHeader());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out instanceof Closeable) {
            ((Closeable)((Object)this.out)).close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out instanceof Flushable) {
            ((Flushable)((Object)this.out)).flush();
        }
    }

    public void print(Object value2) throws IOException {
        String nullString;
        String strValue = value2 == null ? ((nullString = this.format.getNullString()) == null ? "" : nullString) : value2.toString();
        this.print(value2, strValue, 0, strValue.length());
    }

    private void print(Object object, CharSequence value2, int offset, int len) throws IOException {
        if (!this.newRecord) {
            this.out.append(this.format.getDelimiter());
        }
        if (this.format.isQuoteCharacterSet()) {
            this.printAndQuote(object, value2, offset, len);
        } else if (this.format.isEscapeCharacterSet()) {
            this.printAndEscape(value2, offset, len);
        } else {
            this.out.append(value2, offset, offset + len);
        }
        this.newRecord = false;
    }

    private void printAndEscape(CharSequence value2, int offset, int len) throws IOException {
        int pos;
        int start = offset;
        int end = offset + len;
        char delim = this.format.getDelimiter();
        char escape2 = this.format.getEscapeCharacter().charValue();
        for (pos = offset; pos < end; ++pos) {
            char c = value2.charAt(pos);
            if (c != '\r' && c != '\n' && c != delim && c != escape2) continue;
            if (pos > start) {
                this.out.append(value2, start, pos);
            }
            if (c == '\n') {
                c = 'n';
            } else if (c == '\r') {
                c = 'r';
            }
            this.out.append(escape2);
            this.out.append(c);
            start = pos + 1;
        }
        if (pos > start) {
            this.out.append(value2, start, pos);
        }
    }

    private void printAndQuote(Object object, CharSequence value2, int offset, int len) throws IOException {
        char c;
        boolean quote = false;
        int start = offset;
        int pos = offset;
        int end = offset + len;
        char delimChar = this.format.getDelimiter();
        char quoteChar = this.format.getQuoteCharacter().charValue();
        QuoteMode quoteModePolicy = this.format.getQuoteMode();
        if (quoteModePolicy == null) {
            quoteModePolicy = QuoteMode.MINIMAL;
        }
        switch (quoteModePolicy) {
            case ALL: {
                quote = true;
                break;
            }
            case NON_NUMERIC: {
                quote = !(object instanceof Number);
                break;
            }
            case NONE: {
                this.printAndEscape(value2, offset, len);
                return;
            }
            case MINIMAL: {
                if (len <= 0) {
                    if (this.newRecord) {
                        quote = true;
                    }
                } else {
                    c = value2.charAt(pos);
                    if (this.newRecord && (c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z')) {
                        quote = true;
                    } else if (c <= '#') {
                        quote = true;
                    } else {
                        while (pos < end) {
                            c = value2.charAt(pos);
                            if (c == '\n' || c == '\r' || c == quoteChar || c == delimChar) {
                                quote = true;
                                break;
                            }
                            ++pos;
                        }
                        if (!quote && (c = value2.charAt(pos = end - 1)) <= ' ') {
                            quote = true;
                        }
                    }
                }
                if (quote) break;
                this.out.append(value2, start, end);
                return;
            }
            default: {
                throw new IllegalStateException("Unexpected Quote value: " + (Object)((Object)quoteModePolicy));
            }
        }
        if (!quote) {
            this.out.append(value2, start, end);
            return;
        }
        this.out.append(quoteChar);
        while (pos < end) {
            c = value2.charAt(pos);
            if (c == quoteChar) {
                this.out.append(value2, start, pos + 1);
                start = pos;
            }
            ++pos;
        }
        this.out.append(value2, start, pos);
        this.out.append(quoteChar);
    }

    public void printComment(String comment2) throws IOException {
        if (!this.format.isCommentMarkerSet()) {
            return;
        }
        if (!this.newRecord) {
            this.println();
        }
        this.out.append(this.format.getCommentMarker().charValue());
        this.out.append(' ');
        block4: for (int i = 0; i < comment2.length(); ++i) {
            char c = comment2.charAt(i);
            switch (c) {
                case '\r': {
                    if (i + 1 < comment2.length() && comment2.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    this.println();
                    this.out.append(this.format.getCommentMarker().charValue());
                    this.out.append(' ');
                    continue block4;
                }
                default: {
                    this.out.append(c);
                }
            }
        }
        this.println();
    }

    public void println() throws IOException {
        String recordSeparator = this.format.getRecordSeparator();
        if (recordSeparator != null) {
            this.out.append(recordSeparator);
        }
        this.newRecord = true;
    }

    public void printRecord(Iterable<?> values2) throws IOException {
        for (Object value2 : values2) {
            this.print(value2);
        }
        this.println();
    }

    public void printRecord(Object ... values2) throws IOException {
        for (Object value2 : values2) {
            this.print(value2);
        }
        this.println();
    }

    public void printRecords(Iterable<?> values2) throws IOException {
        for (Object value2 : values2) {
            if (value2 instanceof Object[]) {
                this.printRecord((Object[])value2);
                continue;
            }
            if (value2 instanceof Iterable) {
                this.printRecord((Iterable)value2);
                continue;
            }
            this.printRecord(value2);
        }
    }

    public void printRecords(Object ... values2) throws IOException {
        for (Object value2 : values2) {
            if (value2 instanceof Object[]) {
                this.printRecord((Object[])value2);
                continue;
            }
            if (value2 instanceof Iterable) {
                this.printRecord((Iterable)value2);
                continue;
            }
            this.printRecord(value2);
        }
    }

    public void printRecords(ResultSet resultSet) throws SQLException, IOException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            for (int i = 1; i <= columnCount; ++i) {
                this.print(resultSet.getObject(i));
            }
            this.println();
        }
    }

    public Appendable getOut() {
        return this.out;
    }
}

