/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.ExtendedBufferedReader;
import org.apache.commons.csv.Token;

final class Lexer
implements Closeable {
    private static final char DISABLED = '\ufffe';
    private final char delimiter;
    private final char escape;
    private final char quoteChar;
    private final char commentStart;
    private final boolean ignoreSurroundingSpaces;
    private final boolean ignoreEmptyLines;
    private final ExtendedBufferedReader reader;

    Lexer(CSVFormat format2, ExtendedBufferedReader reader) {
        this.reader = reader;
        this.delimiter = format2.getDelimiter();
        this.escape = this.mapNullToDisabled(format2.getEscapeCharacter());
        this.quoteChar = this.mapNullToDisabled(format2.getQuoteCharacter());
        this.commentStart = this.mapNullToDisabled(format2.getCommentMarker());
        this.ignoreSurroundingSpaces = format2.getIgnoreSurroundingSpaces();
        this.ignoreEmptyLines = format2.getIgnoreEmptyLines();
    }

    Token nextToken(Token token2) throws IOException {
        int lastChar = this.reader.getLastChar();
        int c = this.reader.read();
        boolean eol = this.readEndOfLine(c);
        if (this.ignoreEmptyLines) {
            while (eol && this.isStartOfLine(lastChar)) {
                lastChar = c;
                c = this.reader.read();
                eol = this.readEndOfLine(c);
                if (!this.isEndOfFile(c)) continue;
                token2.type = Token.Type.EOF;
                return token2;
            }
        }
        if (this.isEndOfFile(lastChar) || !this.isDelimiter(lastChar) && this.isEndOfFile(c)) {
            token2.type = Token.Type.EOF;
            return token2;
        }
        if (this.isStartOfLine(lastChar) && this.isCommentStart(c)) {
            String line = this.reader.readLine();
            if (line == null) {
                token2.type = Token.Type.EOF;
                return token2;
            }
            String comment2 = line.trim();
            token2.content.append(comment2);
            token2.type = Token.Type.COMMENT;
            return token2;
        }
        while (token2.type == Token.Type.INVALID) {
            if (this.ignoreSurroundingSpaces) {
                while (this.isWhitespace(c) && !eol) {
                    c = this.reader.read();
                    eol = this.readEndOfLine(c);
                }
            }
            if (this.isDelimiter(c)) {
                token2.type = Token.Type.TOKEN;
                continue;
            }
            if (eol) {
                token2.type = Token.Type.EORECORD;
                continue;
            }
            if (this.isQuoteChar(c)) {
                this.parseEncapsulatedToken(token2);
                continue;
            }
            if (this.isEndOfFile(c)) {
                token2.type = Token.Type.EOF;
                token2.isReady = true;
                continue;
            }
            this.parseSimpleToken(token2, c);
        }
        return token2;
    }

    private Token parseSimpleToken(Token token2, int ch) throws IOException {
        while (true) {
            if (this.readEndOfLine(ch)) {
                token2.type = Token.Type.EORECORD;
                break;
            }
            if (this.isEndOfFile(ch)) {
                token2.type = Token.Type.EOF;
                token2.isReady = true;
                break;
            }
            if (this.isDelimiter(ch)) {
                token2.type = Token.Type.TOKEN;
                break;
            }
            if (this.isEscape(ch)) {
                int unescaped = this.readEscape();
                if (unescaped == -1) {
                    token2.content.append((char)ch).append((char)this.reader.getLastChar());
                } else {
                    token2.content.append((char)unescaped);
                }
                ch = this.reader.read();
                continue;
            }
            token2.content.append((char)ch);
            ch = this.reader.read();
        }
        if (this.ignoreSurroundingSpaces) {
            this.trimTrailingSpaces(token2.content);
        }
        return token2;
    }

    private Token parseEncapsulatedToken(Token token2) throws IOException {
        long startLineNumber = this.getCurrentLineNumber();
        while (true) {
            int c;
            if (this.isEscape(c = this.reader.read())) {
                int unescaped = this.readEscape();
                if (unescaped == -1) {
                    token2.content.append((char)c).append((char)this.reader.getLastChar());
                    continue;
                }
                token2.content.append((char)unescaped);
                continue;
            }
            if (this.isQuoteChar(c)) {
                if (this.isQuoteChar(this.reader.lookAhead())) {
                    c = this.reader.read();
                    token2.content.append((char)c);
                    continue;
                }
                do {
                    if (this.isDelimiter(c = this.reader.read())) {
                        token2.type = Token.Type.TOKEN;
                        return token2;
                    }
                    if (this.isEndOfFile(c)) {
                        token2.type = Token.Type.EOF;
                        token2.isReady = true;
                        return token2;
                    }
                    if (!this.readEndOfLine(c)) continue;
                    token2.type = Token.Type.EORECORD;
                    return token2;
                } while (this.isWhitespace(c));
                throw new IOException("(line " + this.getCurrentLineNumber() + ") invalid char between encapsulated token and delimiter");
            }
            if (this.isEndOfFile(c)) {
                throw new IOException("(startline " + startLineNumber + ") EOF reached before encapsulated token finished");
            }
            token2.content.append((char)c);
        }
    }

    private char mapNullToDisabled(Character c) {
        return c == null ? (char)'\ufffe' : (char)c.charValue();
    }

    long getCurrentLineNumber() {
        return this.reader.getCurrentLineNumber();
    }

    long getCharacterPosition() {
        return this.reader.getPosition();
    }

    int readEscape() throws IOException {
        int ch = this.reader.read();
        switch (ch) {
            case 114: {
                return 13;
            }
            case 110: {
                return 10;
            }
            case 116: {
                return 9;
            }
            case 98: {
                return 8;
            }
            case 102: {
                return 12;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                return ch;
            }
            case -1: {
                throw new IOException("EOF whilst processing escape sequence");
            }
        }
        if (this.isMetaChar(ch)) {
            return ch;
        }
        return -1;
    }

    void trimTrailingSpaces(StringBuilder buffer) {
        int length;
        for (length = buffer.length(); length > 0 && Character.isWhitespace(buffer.charAt(length - 1)); --length) {
        }
        if (length != buffer.length()) {
            buffer.setLength(length);
        }
    }

    boolean readEndOfLine(int ch) throws IOException {
        if (ch == 13 && this.reader.lookAhead() == 10) {
            ch = this.reader.read();
        }
        return ch == 10 || ch == 13;
    }

    boolean isClosed() {
        return this.reader.isClosed();
    }

    boolean isWhitespace(int ch) {
        return !this.isDelimiter(ch) && Character.isWhitespace((char)ch);
    }

    boolean isStartOfLine(int ch) {
        return ch == 10 || ch == 13 || ch == -2;
    }

    boolean isEndOfFile(int ch) {
        return ch == -1;
    }

    boolean isDelimiter(int ch) {
        return ch == this.delimiter;
    }

    boolean isEscape(int ch) {
        return ch == this.escape;
    }

    boolean isQuoteChar(int ch) {
        return ch == this.quoteChar;
    }

    boolean isCommentStart(int ch) {
        return ch == this.commentStart;
    }

    private boolean isMetaChar(int ch) {
        return ch == this.delimiter || ch == this.escape || ch == this.quoteChar || ch == this.commentStart;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

