/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import org.apache.kafka.common.TopicPartition;

public final class ConsumerRecord<K, V> {
    private final TopicPartition partition;
    private final K key;
    private final V value;
    private final long offset;
    private volatile Exception error;

    public ConsumerRecord(String topic, int partitionId, K key, V value2, long offset) {
        this(topic, partitionId, key, value2, offset, null);
    }

    public ConsumerRecord(String topic, int partitionId, V value2, long offset) {
        this(topic, partitionId, null, value2, offset);
    }

    public ConsumerRecord(String topic, int partitionId, Exception error2) {
        this(topic, partitionId, null, null, -1L, error2);
    }

    private ConsumerRecord(String topic, int partitionId, K key, V value2, long offset, Exception error2) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null");
        }
        this.partition = new TopicPartition(topic, partitionId);
        this.key = key;
        this.value = value2;
        this.offset = offset;
        this.error = error2;
    }

    public String topic() {
        return this.partition.topic();
    }

    public int partition() {
        return this.partition.partition();
    }

    public TopicPartition topicAndPartition() {
        return this.partition;
    }

    public K key() throws Exception {
        if (this.error != null) {
            throw this.error;
        }
        return this.key;
    }

    public V value() throws Exception {
        if (this.error != null) {
            throw this.error;
        }
        return this.value;
    }

    public long offset() throws Exception {
        if (this.error != null) {
            throw this.error;
        }
        return this.offset;
    }

    public Exception error() {
        return this.error;
    }
}

