/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.ProduceRequestResult;

public final class FutureRecordMetadata
implements Future<RecordMetadata> {
    private final ProduceRequestResult result;
    private final long relativeOffset;

    public FutureRecordMetadata(ProduceRequestResult result2, long relativeOffset) {
        this.result = result2;
        this.relativeOffset = relativeOffset;
    }

    @Override
    public boolean cancel(boolean interrupt) {
        return false;
    }

    @Override
    public RecordMetadata get() throws InterruptedException, ExecutionException {
        this.result.await();
        return this.valueOrError();
    }

    @Override
    public RecordMetadata get(long timeout, TimeUnit unit2) throws InterruptedException, ExecutionException, TimeoutException {
        boolean occurred = this.result.await(timeout, unit2);
        if (!occurred) {
            throw new TimeoutException("Timeout after waiting for " + TimeUnit.MILLISECONDS.convert(timeout, unit2) + " ms.");
        }
        return this.valueOrError();
    }

    private RecordMetadata valueOrError() throws ExecutionException {
        if (this.result.error() != null) {
            throw new ExecutionException(this.result.error());
        }
        return new RecordMetadata(this.result.topicPartition(), this.result.baseOffset(), this.relativeOffset);
    }

    public long relativeOffset() {
        return this.relativeOffset;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.result.completed();
    }
}

