/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.internals.BufferPool;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.RecordBatch;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.CopyOnWriteMap;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordAccumulator {
    private static final Logger log = LoggerFactory.getLogger(RecordAccumulator.class);
    private volatile boolean closed = false;
    private int drainIndex = 0;
    private final int batchSize;
    private final long lingerMs;
    private final long retryBackoffMs;
    private final BufferPool free;
    private final Time time;
    private final ConcurrentMap<TopicPartition, Deque<RecordBatch>> batches;

    public RecordAccumulator(int batchSize, long totalSize, long lingerMs, long retryBackoffMs, boolean blockOnBufferFull, Metrics metrics, Time time, Map<String, String> metricTags) {
        this.batchSize = batchSize;
        this.lingerMs = lingerMs;
        this.retryBackoffMs = retryBackoffMs;
        this.batches = new CopyOnWriteMap<TopicPartition, Deque<RecordBatch>>();
        String metricGrpName = "producer-metrics";
        this.free = new BufferPool(totalSize, batchSize, blockOnBufferFull, metrics, time, metricGrpName, metricTags);
        this.time = time;
        this.registerMetrics(metrics, metricGrpName, metricTags);
    }

    private void registerMetrics(Metrics metrics, String metricGrpName, Map<String, String> metricTags) {
        MetricName metricName = new MetricName("waiting-threads", metricGrpName, "The number of user threads blocked waiting for buffer memory to enqueue their records", metricTags);
        metrics.addMetric(metricName, new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return RecordAccumulator.this.free.queued();
            }
        });
        metricName = new MetricName("buffer-total-bytes", metricGrpName, "The maximum amount of buffer memory the client can use (whether or not it is currently used).", metricTags);
        metrics.addMetric(metricName, new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return RecordAccumulator.this.free.totalMemory();
            }
        });
        metricName = new MetricName("buffer-available-bytes", metricGrpName, "The total amount of buffer memory that is not being used (either unallocated or in the free list).", metricTags);
        metrics.addMetric(metricName, new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return RecordAccumulator.this.free.availableMemory();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordAppendResult append(TopicPartition tp, byte[] key, byte[] value2, CompressionType compression, Callback callback) throws InterruptedException {
        Deque<RecordBatch> dq;
        if (this.closed) {
            throw new IllegalStateException("Cannot send after the producer is closed.");
        }
        Deque<RecordBatch> deque = dq = this.dequeFor(tp);
        synchronized (deque) {
            FutureRecordMetadata future;
            RecordBatch last2 = dq.peekLast();
            if (last2 != null && (future = last2.tryAppend(key, value2, callback)) != null) {
                return new RecordAppendResult(future, dq.size() > 1 || last2.records.isFull(), false);
            }
        }
        int size2 = Math.max(this.batchSize, 12 + Record.recordSize(key, value2));
        log.trace("Allocating a new {} byte message buffer for topic {} partition {}", size2, tp.topic(), tp.partition());
        ByteBuffer buffer = this.free.allocate(size2);
        Deque<RecordBatch> deque2 = dq;
        synchronized (deque2) {
            FutureRecordMetadata future;
            RecordBatch last3 = dq.peekLast();
            if (last3 != null && (future = last3.tryAppend(key, value2, callback)) != null) {
                this.free.deallocate(buffer);
                return new RecordAppendResult(future, dq.size() > 1 || last3.records.isFull(), false);
            }
            MemoryRecords records = MemoryRecords.emptyRecords(buffer, compression, this.batchSize);
            RecordBatch batch = new RecordBatch(tp, records, this.time.milliseconds());
            FutureRecordMetadata future2 = Utils.notNull(batch.tryAppend(key, value2, callback));
            dq.addLast(batch);
            return new RecordAppendResult(future2, dq.size() > 1 || batch.records.isFull(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reenqueue(RecordBatch batch, long now) {
        Deque<RecordBatch> deque;
        ++batch.attempts;
        batch.lastAttemptMs = now;
        Deque<RecordBatch> deque2 = deque = this.dequeFor(batch.topicPartition);
        synchronized (deque2) {
            deque.addFirst(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadyCheckResult ready(Cluster cluster, long nowMs) {
        HashSet<Node> readyNodes = new HashSet<Node>();
        long nextReadyCheckDelayMs = Long.MAX_VALUE;
        boolean unknownLeadersExist = false;
        boolean exhausted = this.free.queued() > 0;
        for (Map.Entry entry2 : this.batches.entrySet()) {
            TopicPartition part = (TopicPartition)entry2.getKey();
            Deque deque = (Deque)entry2.getValue();
            Node leader = cluster.leaderFor(part);
            if (leader == null) {
                unknownLeadersExist = true;
                continue;
            }
            if (readyNodes.contains(leader)) continue;
            Deque deque2 = deque;
            synchronized (deque2) {
                RecordBatch batch = (RecordBatch)deque.peekFirst();
                if (batch != null) {
                    boolean sendable;
                    boolean backingOff = batch.attempts > 0 && batch.lastAttemptMs + this.retryBackoffMs > nowMs;
                    long waitedTimeMs = nowMs - batch.lastAttemptMs;
                    long timeToWaitMs = backingOff ? this.retryBackoffMs : this.lingerMs;
                    long timeLeftMs = Math.max(timeToWaitMs - waitedTimeMs, 0L);
                    boolean full = deque.size() > 1 || batch.records.isFull();
                    boolean expired = waitedTimeMs >= timeToWaitMs;
                    boolean bl = sendable = full || expired || exhausted || this.closed;
                    if (sendable && !backingOff) {
                        readyNodes.add(leader);
                    } else {
                        nextReadyCheckDelayMs = Math.min(timeLeftMs, nextReadyCheckDelayMs);
                    }
                }
            }
        }
        return new ReadyCheckResult(readyNodes, nextReadyCheckDelayMs, unknownLeadersExist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnsent() {
        for (Map.Entry entry2 : this.batches.entrySet()) {
            Deque deque;
            Deque deque2 = deque = (Deque)entry2.getValue();
            synchronized (deque2) {
                if (deque.size() > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, List<RecordBatch>> drain(Cluster cluster, Set<Node> nodes2, int maxSize, long now) {
        if (nodes2.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<RecordBatch>> batches = new HashMap<Integer, List<RecordBatch>>();
        for (Node node : nodes2) {
            int size2 = 0;
            List<PartitionInfo> parts = cluster.partitionsForNode(node.id());
            ArrayList<RecordBatch> ready2 = new ArrayList<RecordBatch>();
            int start = this.drainIndex %= parts.size();
            do {
                PartitionInfo part;
                Deque<RecordBatch> deque;
                if ((deque = this.dequeFor(new TopicPartition((part = parts.get(this.drainIndex)).topic(), part.partition()))) != null) {
                    Deque<RecordBatch> deque2 = deque;
                    synchronized (deque2) {
                        RecordBatch first = deque.peekFirst();
                        if (first != null) {
                            if (size2 + first.records.sizeInBytes() > maxSize && !ready2.isEmpty()) {
                                break;
                            }
                            RecordBatch batch = deque.pollFirst();
                            batch.records.close();
                            size2 += batch.records.sizeInBytes();
                            ready2.add(batch);
                            batch.drainedMs = now;
                        }
                    }
                }
                this.drainIndex = (this.drainIndex + 1) % parts.size();
            } while (start != this.drainIndex);
            batches.put(node.id(), ready2);
        }
        return batches;
    }

    private Deque<RecordBatch> dequeFor(TopicPartition tp) {
        Deque d = (Deque)this.batches.get(tp);
        if (d != null) {
            return d;
        }
        this.batches.putIfAbsent(tp, new ArrayDeque());
        return (Deque)this.batches.get(tp);
    }

    public void deallocate(RecordBatch batch) {
        this.free.deallocate(batch.records.buffer(), batch.records.capacity());
    }

    public void close() {
        this.closed = true;
    }

    public static final class ReadyCheckResult {
        public final Set<Node> readyNodes;
        public final long nextReadyCheckDelayMs;
        public final boolean unknownLeadersExist;

        public ReadyCheckResult(Set<Node> readyNodes, long nextReadyCheckDelayMs, boolean unknownLeadersExist) {
            this.readyNodes = readyNodes;
            this.nextReadyCheckDelayMs = nextReadyCheckDelayMs;
            this.unknownLeadersExist = unknownLeadersExist;
        }
    }

    public static final class RecordAppendResult {
        public final FutureRecordMetadata future;
        public final boolean batchIsFull;
        public final boolean newBatchCreated;

        public RecordAppendResult(FutureRecordMetadata future, boolean batchIsFull, boolean newBatchCreated) {
            this.future = future;
            this.batchIsFull = batchIsFull;
            this.newBatchCreated = newBatchCreated;
        }
    }
}

