/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Type;

public class ArrayOf
extends Type {
    private final Type type;

    public ArrayOf(Type type) {
        this.type = type;
    }

    @Override
    public void write(ByteBuffer buffer, Object o) {
        Object[] objs = (Object[])o;
        int size2 = objs.length;
        buffer.putInt(size2);
        for (int i = 0; i < size2; ++i) {
            this.type.write(buffer, objs[i]);
        }
    }

    @Override
    public Object read(ByteBuffer buffer) {
        int size2 = buffer.getInt();
        Object[] objs = new Object[size2];
        for (int i = 0; i < size2; ++i) {
            objs[i] = this.type.read(buffer);
        }
        return objs;
    }

    @Override
    public int sizeOf(Object o) {
        Object[] objs = (Object[])o;
        int size2 = 4;
        for (int i = 0; i < objs.length; ++i) {
            size2 += this.type.sizeOf(objs[i]);
        }
        return size2;
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return "ARRAY(" + this.type + ")";
    }

    public Object[] validate(Object item) {
        try {
            Object[] array2 = (Object[])item;
            for (int i = 0; i < array2.length; ++i) {
                this.type.validate(array2[i]);
            }
            return array2;
        }
        catch (ClassCastException e) {
            throw new SchemaException("Not an Object[].");
        }
    }
}

