/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.Iterator;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.record.ByteBufferInputStream;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.Compressor;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.AbstractIterator;

public class MemoryRecords
implements Records {
    private final Compressor compressor;
    private final int capacity;
    private final int sizeLimit;
    private ByteBuffer buffer;
    private boolean writable;

    private MemoryRecords(ByteBuffer buffer, CompressionType type, boolean writable, int sizeLimit) {
        this.writable = writable;
        this.capacity = buffer.capacity();
        this.sizeLimit = sizeLimit;
        if (this.writable) {
            this.buffer = null;
            this.compressor = new Compressor(buffer, type);
        } else {
            this.buffer = buffer;
            this.compressor = null;
        }
    }

    public static MemoryRecords emptyRecords(ByteBuffer buffer, CompressionType type, int capacity) {
        return new MemoryRecords(buffer, type, true, capacity);
    }

    public static MemoryRecords emptyRecords(ByteBuffer buffer, CompressionType type) {
        return MemoryRecords.emptyRecords(buffer, type, buffer.capacity());
    }

    public static MemoryRecords iterableRecords(ByteBuffer buffer) {
        return new MemoryRecords(buffer, CompressionType.NONE, false, buffer.capacity());
    }

    public void append(long offset, Record record2) {
        if (!this.writable) {
            throw new IllegalStateException("Memory records is not writable");
        }
        int size2 = record2.size();
        this.compressor.putLong(offset);
        this.compressor.putInt(size2);
        this.compressor.put(record2.buffer());
        this.compressor.recordWritten(size2 + 12);
        record2.buffer().rewind();
    }

    public void append(long offset, byte[] key, byte[] value2) {
        if (!this.writable) {
            throw new IllegalStateException("Memory records is not writable");
        }
        int size2 = Record.recordSize(key, value2);
        this.compressor.putLong(offset);
        this.compressor.putInt(size2);
        this.compressor.putRecord(key, value2);
        this.compressor.recordWritten(size2 + 12);
    }

    public boolean hasRoomFor(byte[] key, byte[] value2) {
        return this.writable && (long)this.capacity >= this.compressor.estimatedBytesWritten() + 12L + (long)Record.recordSize(key, value2) && (long)this.sizeLimit >= this.compressor.estimatedBytesWritten();
    }

    public boolean isFull() {
        return !this.writable || (long)this.capacity <= this.compressor.estimatedBytesWritten() || (long)this.sizeLimit <= this.compressor.estimatedBytesWritten();
    }

    public void close() {
        this.compressor.close();
        this.writable = false;
        this.buffer = this.compressor.buffer();
    }

    @Override
    public int writeTo(GatheringByteChannel channel) throws IOException {
        return channel.write(this.buffer);
    }

    @Override
    public int sizeInBytes() {
        return this.compressor.buffer().position();
    }

    public double compressionRate() {
        if (this.compressor == null) {
            return 1.0;
        }
        return this.compressor.compressionRate();
    }

    public int capacity() {
        return this.capacity;
    }

    public ByteBuffer buffer() {
        return this.buffer.duplicate();
    }

    @Override
    public Iterator<LogEntry> iterator() {
        ByteBuffer copy = (ByteBuffer)this.buffer.duplicate().flip();
        return new RecordsIterator(copy, CompressionType.NONE, false);
    }

    public static class RecordsIterator
    extends AbstractIterator<LogEntry> {
        private final ByteBuffer buffer;
        private final DataInputStream stream;
        private final CompressionType type;
        private final boolean shallow;
        private RecordsIterator innerIter;

        public RecordsIterator(ByteBuffer buffer, CompressionType type, boolean shallow) {
            this.type = type;
            this.buffer = buffer;
            this.shallow = shallow;
            this.stream = Compressor.wrapForInput(new ByteBufferInputStream(this.buffer), type);
        }

        @Override
        protected LogEntry makeNext() {
            if (this.innerDone()) {
                try {
                    ByteBuffer rec;
                    long offset = this.stream.readLong();
                    int size2 = this.stream.readInt();
                    if (size2 < 0) {
                        throw new IllegalStateException("Record with size " + size2);
                    }
                    if (this.type == CompressionType.NONE) {
                        rec = this.buffer.slice();
                        this.buffer.position(this.buffer.position() + size2);
                        rec.limit(size2);
                    } else {
                        byte[] recordBuffer = new byte[size2];
                        this.stream.read(recordBuffer, 0, size2);
                        rec = ByteBuffer.wrap(recordBuffer);
                    }
                    LogEntry entry2 = new LogEntry(offset, new Record(rec));
                    entry2.record().ensureValid();
                    CompressionType compression = entry2.record().compressionType();
                    if (compression == CompressionType.NONE || this.shallow) {
                        return entry2;
                    }
                    ByteBuffer value2 = entry2.record().value();
                    this.innerIter = new RecordsIterator(value2, compression, true);
                    return (LogEntry)this.innerIter.next();
                }
                catch (EOFException e) {
                    return (LogEntry)this.allDone();
                }
                catch (IOException e) {
                    throw new KafkaException(e);
                }
            }
            return (LogEntry)this.innerIter.next();
        }

        private boolean innerDone() {
            return this.innerIter == null || !this.innerIter.hasNext();
        }
    }
}

