/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.KafkaException;

public class Utils {
    private static final Pattern HOST_PORT_PATTERN = Pattern.compile("\\[?(.+?)\\]?:(\\d+)");
    public static String NL = System.getProperty("line.separator");

    public static String utf8(byte[] bytes2) {
        try {
            return new String(bytes2, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This shouldn't happen.", e);
        }
    }

    public static byte[] utf8(String string2) {
        try {
            return string2.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This shouldn't happen.", e);
        }
    }

    public static long readUnsignedInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public static long readUnsignedInt(ByteBuffer buffer, int index2) {
        return (long)buffer.getInt(index2) & 0xFFFFFFFFL;
    }

    public static int readUnsignedIntLE(InputStream in) throws IOException {
        return in.read() << 0 | in.read() << 8 | in.read() << 16 | in.read() << 24;
    }

    public static int readUnsignedIntLE(byte[] buffer, int offset) {
        return buffer[offset++] << 0 | buffer[offset++] << 8 | buffer[offset++] << 16 | buffer[offset] << 24;
    }

    public static void writetUnsignedInt(ByteBuffer buffer, long value2) {
        buffer.putInt((int)(value2 & 0xFFFFFFFFL));
    }

    public static void writeUnsignedInt(ByteBuffer buffer, int index2, long value2) {
        buffer.putInt(index2, (int)(value2 & 0xFFFFFFFFL));
    }

    public static void writeUnsignedIntLE(OutputStream out, int value2) throws IOException {
        out.write(value2 >>> 0);
        out.write(value2 >>> 8);
        out.write(value2 >>> 16);
        out.write(value2 >>> 24);
    }

    public static void writeUnsignedIntLE(byte[] buffer, int offset, int value2) {
        buffer[offset++] = (byte)(value2 >>> 0);
        buffer[offset++] = (byte)(value2 >>> 8);
        buffer[offset++] = (byte)(value2 >>> 16);
        buffer[offset] = (byte)(value2 >>> 24);
    }

    public static int abs(int n) {
        return n & Integer.MAX_VALUE;
    }

    public static int utf8Length(CharSequence s2) {
        int count2 = 0;
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            char ch = s2.charAt(i);
            if (ch <= '\u007f') {
                ++count2;
                continue;
            }
            if (ch <= '\u07ff') {
                count2 += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count2 += 4;
                ++i;
                continue;
            }
            count2 += 3;
        }
        return count2;
    }

    public static byte[] toArray(ByteBuffer buffer) {
        return Utils.toArray(buffer, 0, buffer.limit());
    }

    public static byte[] toArray(ByteBuffer buffer, int offset, int size2) {
        byte[] dest = new byte[size2];
        if (buffer.hasArray()) {
            System.arraycopy(buffer.array(), buffer.arrayOffset() + offset, dest, 0, size2);
        } else {
            int pos = buffer.position();
            buffer.get(dest);
            buffer.position(pos);
        }
        return dest;
    }

    public static <T> T notNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static Object newInstance(Class<?> c) {
        try {
            return c.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new KafkaException("Could not instantiate class " + c.getName(), e);
        }
        catch (InstantiationException e) {
            throw new KafkaException("Could not instantiate class " + c.getName() + " Does it have a public no-argument constructor?", e);
        }
    }

    public static int murmur2(byte[] data2) {
        int length = data2.length;
        int seed = -1756908916;
        int m = 1540483477;
        int r = 24;
        int h = seed ^ length;
        int length4 = length / 4;
        for (int i = 0; i < length4; ++i) {
            int i4 = i * 4;
            int k = (data2[i4 + 0] & 0xFF) + ((data2[i4 + 1] & 0xFF) << 8) + ((data2[i4 + 2] & 0xFF) << 16) + ((data2[i4 + 3] & 0xFF) << 24);
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        switch (length % 4) {
            case 3: {
                h ^= (data2[(length & 0xFFFFFFFC) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (data2[(length & 0xFFFFFFFC) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= data2[length & 0xFFFFFFFC] & 0xFF;
                h *= 1540483477;
            }
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return h;
    }

    public static String getHost(String address) {
        Matcher matcher2 = HOST_PORT_PATTERN.matcher(address);
        return matcher2.matches() ? matcher2.group(1) : null;
    }

    public static Integer getPort(String address) {
        Matcher matcher2 = HOST_PORT_PATTERN.matcher(address);
        return matcher2.matches() ? Integer.valueOf(Integer.parseInt(matcher2.group(2))) : null;
    }

    public static String formatAddress(String host, Integer port) {
        return host.contains(":") ? "[" + host + "]:" + port : host + ":" + port;
    }
}

