/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.csharp;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.List;
import java.util.Map;
import org.apache.spark.Accumulator;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.api.csharp.CSharpRDD$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.python.PythonBroadcast;
import org.apache.spark.api.python.PythonRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.csharp.Utils$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0001\u0003\u00015\u0011\u0011bQ*iCJ\u0004(\u000b\u0012#\u000b\u0005\r!\u0011AB2tQ\u0006\u0014\bO\u0003\u0002\u0006\r\u0005\u0019\u0011\r]5\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0007af$\bn\u001c8\n\u0005M\u0001\"!\u0003)zi\"|gN\u0015#E\u0011!)\u0002A!A!\u0002\u00131\u0012A\u00029be\u0016tG\u000f\r\u0002\u0018?A\u0019\u0001dG\u000f\u000e\u0003eQ!A\u0007\u0004\u0002\u0007I$G-\u0003\u0002\u001d3\t\u0019!\u000b\u0012#\u0011\u0005yyB\u0002\u0001\u0003\nAQ\t\t\u0011!A\u0003\u0002\u0005\u00121a\u0018\u00132#\t\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CEA\u0004O_RD\u0017N\\4\u0011\u0005\rJ\u0013B\u0001\u0016%\u0005\r\te.\u001f\u0015\u0003)1\u0002\"aI\u0017\n\u00059\"#!\u0003;sC:\u001c\u0018.\u001a8u\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0014aB2p[6\fg\u000e\u001a\t\u0004GI\"\u0014BA\u001a%\u0005\u0015\t%O]1z!\t\u0019S'\u0003\u00027I\t!!)\u001f;f\u0011!A\u0004A!A!\u0002\u0013I\u0014aB3omZ\u000b'o\u001d\t\u0005u}\n\u0015)D\u0001<\u0015\taT(\u0001\u0003vi&d'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u00121!T1q!\t\u0011UI\u0004\u0002$\u0007&\u0011A\tJ\u0001\u0007!J,G-\u001a4\n\u0005\u0019;%AB*ue&twM\u0003\u0002EI!A\u0011\n\u0001B\u0001B\u0003%!*\u0001\bd'\"\f'\u000f]%oG2,H-Z:\u0011\u0007iZ\u0015)\u0003\u0002Mw\t!A*[:u\u0011!q\u0005A!A!\u0002\u0013y\u0015\u0001\u00069sKN,'O^3QCJ$\u0018\u000e^5p]&tw\r\u0005\u0002$!&\u0011\u0011\u000b\n\u0002\b\u0005>|G.Z1o\u0011!\u0019\u0006A!A!\u0002\u0013\t\u0015AF2TQ\u0006\u0014\boV8sW\u0016\u0014X\t_3dkR\f'\r\\3\t\u0011U\u0003!\u0011!Q\u0001\n\u0005\u000bq#\u001e8Vg\u0016$g+\u001a:tS>t\u0017\nZ3oi&4\u0017.\u001a:\t\u0011]\u0003!\u0011!Q\u0001\na\u000bQB\u0019:pC\u0012\u001c\u0017m\u001d;WCJ\u001c\bc\u0001\u001eL3B\u0019!,X0\u000e\u0003mS!\u0001\u0018\u0004\u0002\u0013\t\u0014x.\u00193dCN$\u0018B\u00010\\\u0005%\u0011%o\\1eG\u0006\u001cH\u000f\u0005\u0002\u0010A&\u0011\u0011\r\u0005\u0002\u0010!f$\bn\u001c8Ce>\fGmY1ti\"A1\r\u0001B\u0001B\u0003%A-A\u0006bG\u000e,X.\u001e7bi>\u0014\bcA3gQ6\ta!\u0003\u0002h\r\tY\u0011iY2v[Vd\u0017\r^8s!\rQ4*\r\u0005\u0006U\u0002!\ta[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00151t7\u000f^;wobL(\u0010\u0005\u0002n\u00015\t!\u0001C\u0003\u0016S\u0002\u0007q\u000e\r\u0002qeB\u0019\u0001dG9\u0011\u0005y\u0011H!\u0003\u0011o\u0003\u0003\u0005\tQ!\u0001\"\u0011\u0015\u0001\u0014\u000e1\u00012\u0011\u0015A\u0014\u000e1\u0001:\u0011\u0015I\u0015\u000e1\u0001K\u0011\u0015q\u0015\u000e1\u0001P\u0011\u0015\u0019\u0016\u000e1\u0001B\u0011\u0015)\u0016\u000e1\u0001B\u0011\u00159\u0016\u000e1\u0001Y\u0011\u0015\u0019\u0017\u000e1\u0001e\u0011\u0015a\b\u0001\"\u0011~\u0003\u001d\u0019w.\u001c9vi\u0016$RA`A\u000b\u0003?\u0001Ba`A\bc9!\u0011\u0011AA\u0006\u001d\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004\u0019\u00051AH]8pizJ\u0011!J\u0005\u0004\u0003\u001b!\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003#\t\u0019B\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\ti\u0001\n\u0005\b\u0003/Y\b\u0019AA\r\u0003\u0015\u0019\b\u000f\\5u!\r)\u00171D\u0005\u0004\u0003;1!!\u0003)beRLG/[8o\u0011\u001d\t\tc\u001fa\u0001\u0003G\tqaY8oi\u0016DH\u000fE\u0002f\u0003KI1!a\n\u0007\u0005-!\u0016m]6D_:$X\r\u001f;\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\u0005)QO\u001c>jaR!\u0011qFA\u001b!\r\u0019\u0013\u0011G\u0005\u0004\u0003g!#\u0001B+oSRD\u0001\"a\u000e\u0002*\u0001\u0007\u0011\u0011H\u0001\u0017GNC\u0017M\u001d9X_J\\WM],pe.Lgn\u001a#jeB!\u00111HA!\u001b\t\tiDC\u0002\u0002@u\n!![8\n\t\u0005\r\u0013Q\b\u0002\u0005\r&dW\rC\u0004\u0002H\u0001!I!!\u0013\u0002-]\f\u0017\u000e^+ou&\u0004x\n]3sCRLwN\u001c#p]\u0016$B!a\f\u0002L!A\u0011QJA#\u0001\u0004\tI$\u0001\u0005e_:,g\t\\1h\u000f\u001d\t\tF\u0001E\u0001\u0003'\n\u0011bQ*iCJ\u0004(\u000b\u0012#\u0011\u00075\f)F\u0002\u0004\u0002\u0005!\u0005\u0011qK\n\u0007\u0003+\nI&a\u0018\u0011\u0007\r\nY&C\u0002\u0002^\u0011\u0012a!\u00118z%\u00164\u0007cA\u0012\u0002b%\u0019\u00111\r\u0013\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f)\f)\u0006\"\u0001\u0002hQ\u0011\u00111\u000b\u0005\t\u0003W\n)\u0006\"\u0001\u0002n\u0005\u00112M]3bi\u0016\u0014F\t\u0012$s_6\f%O]1z)!\ty'!\u001f\u0002\u0004\u0006%\u0005#BA9\u0003k\nTBAA:\u0015\tqD!\u0003\u0003\u0002x\u0005M$a\u0002&bm\u0006\u0014F\t\u0012\u0005\t\u0003w\nI\u00071\u0001\u0002~\u0005\u00111o\u0019\t\u0004K\u0006}\u0014bAAA\r\ta1\u000b]1sW\u000e{g\u000e^3yi\"A\u0011QQA5\u0001\u0004\t9)A\u0002beJ\u00042a\t\u001a2\u0011!\tY)!\u001bA\u0002\u00055\u0015!\u00038v[Nc\u0017nY3t!\r\u0019\u0013qR\u0005\u0004\u0003###aA%oi\"Q\u0011QSA+\u0003\u0003%I!a&\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00033\u0003B!a'\u0002\"6\u0011\u0011Q\u0014\u0006\u0004\u0003?k\u0014\u0001\u00027b]\u001eLA!a)\u0002\u001e\n1qJ\u00196fGR\u0004")
public class CSharpRDD
extends PythonRDD {
    private final String cSharpWorkerExecutable;

    public static JavaRDD<byte[]> createRDDFromArray(SparkContext sparkContext, byte[][] byArray, int n) {
        return CSharpRDD$.MODULE$.createRDDFromArray(sparkContext, byArray, n);
    }

    public Iterator<byte[]> compute(Partition split2, TaskContext context) {
        this.unzip(new File(this.cSharpWorkerExecutable).getAbsoluteFile().getParentFile());
        return super.compute(split2, context);
    }

    private void unzip(File cSharpWorkerWorkingDir) {
        String[] files2 = (String[])Predef$.MODULE$.refArrayOps((Object[])cSharpWorkerWorkingDir.list()).filter(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.toLowerCase().endsWith(".zip");
            }
        });
        String lockName = "_unzip_lock";
        String unzippingFlagName = "_unzipping";
        String doneFlagName = "_unzip_done";
        if (files2.length == 0) {
            this.logWarning((Function0)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Found no zip files.";
                }
            }));
            return;
        }
        this.logInfo((Function0)((Object)new Serializable(this, files2){
            public static final long serialVersionUID = 0L;
            private final String[] files$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Found zip files: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.files$1).mkString(",")).toString();
            }
            {
                this.files$1 = files$1;
            }
        }));
        File doneFlag = new File(cSharpWorkerWorkingDir, doneFlagName);
        if (doneFlag.exists()) {
            this.logInfo((Function0)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Already unzipped all zip files, skip.";
                }
            }));
            return;
        }
        File unzippingFlag = new File(cSharpWorkerWorkingDir, unzippingFlagName);
        if (unzippingFlag.exists()) {
            this.waitUnzipOperationDone(doneFlag);
            return;
        }
        File lockFile = new File(cSharpWorkerWorkingDir, lockName);
        RandomAccessFile file = null;
        FileLock lock2 = null;
        AbstractInterruptibleChannel channel = null;
        try {
            file = new RandomAccessFile(lockFile, "rw");
            channel = file.getChannel();
            lock2 = ((FileChannel)channel).tryLock();
            if (lock2 == null) {
                this.logWarning((Function0)((Object)new Serializable(this, lockFile){
                    public static final long serialVersionUID = 0L;
                    private final File lockFile$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Failed to obtain lock for file ").append((Object)this.lockFile$1.getPath()).toString();
                    }
                    {
                        this.lockFile$1 = lockFile$1;
                    }
                }));
                this.waitUnzipOperationDone(doneFlag);
                return;
            }
            if (new File(cSharpWorkerWorkingDir, doneFlagName).exists()) {
                return;
            }
            unzippingFlag.createNewFile();
            Predef$.MODULE$.refArrayOps((Object[])files2).foreach(new Serializable(this, cSharpWorkerWorkingDir){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CSharpRDD $outer;
                private final File cSharpWorkerWorkingDir$1;

                public final void apply(String zipFile) {
                    Utils$.MODULE$.unzip(new File(this.cSharpWorkerWorkingDir$1, zipFile), this.cSharpWorkerWorkingDir$1);
                    this.$outer.logInfo((Function0)((Object)new Serializable(this, zipFile){
                        public static final long serialVersionUID = 0L;
                        private final String zipFile$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Unzip file: ").append((Object)this.zipFile$1).toString();
                        }
                        {
                            this.zipFile$1 = zipFile$1;
                        }
                    }));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.cSharpWorkerWorkingDir$1 = cSharpWorkerWorkingDir$1;
                }
            });
            doneFlag.createNewFile();
            unzippingFlag.delete();
            this.logInfo((Function0)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Unzip done.";
                }
            }));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.logInfo((Function0)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Already obtained the lock.";
                }
            }));
            this.waitUnzipOperationDone(doneFlag);
        }
        finally {
            if (lock2 != null && lock2.isValid()) {
                lock2.release();
            }
            if (channel != null && channel.isOpen()) {
                channel.close();
            }
            if (file != null) {
                file.close();
            }
        }
    }

    private void waitUnzipOperationDone(File doneFlag) {
        int maxSleepTimeInSeconds = 30;
        int sleepTimeInSeconds = 0;
        int interval = 5;
        while (!doneFlag.exists()) {
            if (sleepTimeInSeconds > maxSleepTimeInSeconds) {
                return;
            }
            sleepTimeInSeconds += interval;
            Thread.sleep(5000L);
        }
        return;
    }

    public CSharpRDD(RDD<?> parent, byte[] command2, Map<String, String> envVars, List<String> cSharpIncludes, boolean preservePartitioning, String cSharpWorkerExecutable, String unUsedVersionIdentifier, List<Broadcast<PythonBroadcast>> broadcastVars, Accumulator<List<byte[]>> accumulator) {
        this.cSharpWorkerExecutable = cSharpWorkerExecutable;
        super(parent, command2, envVars, cSharpIncludes, preservePartitioning, cSharpWorkerExecutable, unUsedVersionIdentifier, broadcastVars, accumulator);
    }
}

