/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.csharp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.api.csharp.JVMObjectTracker$;
import scala.Array$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class SerDe$ {
    public static final SerDe$ MODULE$;

    static {
        new SerDe$();
    }

    public char readObjectType(DataInputStream dis) {
        return (char)dis.readByte();
    }

    public Object readObject(DataInputStream dis) {
        char dataType = this.readObjectType(dis);
        return this.readTypedObject(dis, dataType);
    }

    public Object readTypedObject(DataInputStream dis, char dataType) {
        Object object;
        char c = dataType;
        switch (c) {
            default: {
                throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid type ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToCharacter(dataType)})));
            }
            case 'j': {
                object = JVMObjectTracker$.MODULE$.getObject(this.readString(dis));
                break;
            }
            case 't': {
                object = this.readTime(dis);
                break;
            }
            case 'D': {
                object = this.readDate(dis);
                break;
            }
            case 'l': {
                object = this.readList(dis);
                break;
            }
            case 'r': {
                object = this.readBytes(dis);
                break;
            }
            case 'e': {
                object = this.readMap(dis);
                break;
            }
            case 'c': {
                object = this.readString(dis);
                break;
            }
            case 'b': {
                object = new Boolean(this.readBoolean(dis));
                break;
            }
            case 'd': {
                object = new Double(this.readDouble(dis));
                break;
            }
            case 'g': {
                object = new Long(this.readLong(dis));
                break;
            }
            case 'i': {
                object = new Integer(this.readInt(dis));
                break;
            }
            case 'n': {
                object = null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readBytes(DataInputStream in) {
        void var3_3;
        int len = this.readInt(in);
        byte[] out = new byte[len];
        in.readFully(out);
        BoxedUnit bytesRead = BoxedUnit.UNIT;
        return var3_3;
    }

    public int readInt(DataInputStream in) {
        return in.readInt();
    }

    public long readLong(DataInputStream in) {
        return in.readLong();
    }

    public double readDouble(DataInputStream in) {
        return in.readDouble();
    }

    public String readStringBytes(DataInputStream in, int len) {
        byte[] bytes2 = new byte[len];
        in.readFully(bytes2);
        String str = new String(bytes2, "UTF-8");
        return str;
    }

    public String readString(DataInputStream in) {
        int len = in.readInt();
        return this.readStringBytes(in, len);
    }

    public boolean readBoolean(DataInputStream in) {
        return in.readBoolean();
    }

    public Date readDate(DataInputStream in) {
        return Date.valueOf(this.readString(in));
    }

    public Timestamp readTime(DataInputStream in) {
        double seconds = in.readDouble();
        long sec = (long)Math.floor(seconds);
        Timestamp t = new Timestamp(sec * 1000L);
        t.setNanos((int)((seconds - (double)sec) * 1.0E9));
        return t;
    }

    public byte[][] readBytesArr(DataInputStream in) {
        int len = this.readInt(in);
        return (byte[][])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map(new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$2;

            public final byte[] apply(int x$1) {
                return SerDe$.MODULE$.readBytes(this.in$2);
            }
            {
                this.in$2 = in$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public int[] readIntArr(DataInputStream in) {
        int len = this.readInt(in);
        return (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map(new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$3;

            public final int apply(int x$2) {
                return this.apply$mcII$sp(x$2);
            }

            public int apply$mcII$sp(int x$2) {
                return SerDe$.MODULE$.readInt(this.in$3);
            }
            {
                this.in$3 = in$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public long[] readLongArr(DataInputStream in) {
        int len = this.readInt(in);
        return (long[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map(new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$4;

            public final long apply(int x$3) {
                return this.apply$mcJI$sp(x$3);
            }

            public long apply$mcJI$sp(int x$3) {
                return SerDe$.MODULE$.readLong(this.in$4);
            }
            {
                this.in$4 = in$4;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
    }

    public double[] readDoubleArr(DataInputStream in) {
        int len = this.readInt(in);
        return (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map(new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$5;

            public final double apply(int x$4) {
                return this.apply$mcDI$sp(x$4);
            }

            public double apply$mcDI$sp(int x$4) {
                return SerDe$.MODULE$.readDouble(this.in$5);
            }
            {
                this.in$5 = in$5;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }

    public boolean[] readBooleanArr(DataInputStream in) {
        int len = this.readInt(in);
        return (boolean[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map(new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$6;

            public final boolean apply(int x$5) {
                return this.apply$mcZI$sp(x$5);
            }

            public boolean apply$mcZI$sp(int x$5) {
                return SerDe$.MODULE$.readBoolean(this.in$6);
            }
            {
                this.in$6 = in$6;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
    }

    public String[] readStringArr(DataInputStream in) {
        int len = this.readInt(in);
        return (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map(new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$7;

            public final String apply(int x$6) {
                return SerDe$.MODULE$.readString(this.in$7);
            }
            {
                this.in$7 = in$7;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Object readList(DataInputStream dis) {
        Object object;
        char arrType;
        char c = arrType = this.readObjectType(dis);
        switch (c) {
            default: {
                throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid array type ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToCharacter(arrType)})));
            }
            case 'r': {
                object = this.readBytesArr(dis);
                break;
            }
            case 'j': {
                object = Predef$.MODULE$.refArrayOps((Object[])this.readStringArr(dis)).map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(String x) {
                        return JVMObjectTracker$.MODULE$.getObject(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object()));
                break;
            }
            case 'b': {
                object = this.readBooleanArr(dis);
                break;
            }
            case 'd': {
                object = this.readDoubleArr(dis);
                break;
            }
            case 'c': {
                object = this.readStringArr(dis);
                break;
            }
            case 'g': {
                object = this.readLongArr(dis);
                break;
            }
            case 'i': {
                object = this.readIntArr(dis);
            }
        }
        return object;
    }

    public Map<Object, Object> readMap(DataInputStream in) {
        Map<Object, Object> map2;
        int len = this.readInt(in);
        if (len > 0) {
            char keysType = this.readObjectType(in);
            int keysLen = this.readInt(in);
            IndexedSeq keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), keysLen).map(new Serializable(in, keysType){
                public static final long serialVersionUID = 0L;
                private final DataInputStream in$1;
                private final char keysType$1;

                public final Object apply(int x$7) {
                    return SerDe$.MODULE$.readTypedObject(this.in$1, this.keysType$1);
                }
                {
                    this.in$1 = in$1;
                    this.keysType$1 = keysType$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            int valuesLen = this.readInt(in);
            IndexedSeq values2 = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesLen).map(new Serializable(in){
                public static final long serialVersionUID = 0L;
                private final DataInputStream in$1;

                public final Object apply(int x$8) {
                    char valueType = SerDe$.MODULE$.readObjectType(this.in$1);
                    return SerDe$.MODULE$.readTypedObject(this.in$1, valueType);
                }
                {
                    this.in$1 = in$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            map2 = JavaConversions$.MODULE$.mapAsJavaMap(((TraversableOnce)keys.zip(values2, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms()));
        } else {
            map2 = new HashMap<Object, Object>();
        }
        return map2;
    }

    public void writeType(DataOutputStream dos, String typeStr) {
        block12: {
            block3: {
                String string2;
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block2: {
                                                    String string3 = string2 = typeStr;
                                                    if ("void" != null ? !"void".equals(string3) : string3 != null) break block2;
                                                    dos.writeByte(110);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block3;
                                                }
                                                String string4 = string2;
                                                if ("character" != null ? !"character".equals(string4) : string4 != null) break block4;
                                                dos.writeByte(99);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            String string5 = string2;
                                            if ("double" != null ? !"double".equals(string5) : string5 != null) break block5;
                                            dos.writeByte(100);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        String string6 = string2;
                                        if ("integer" != null ? !"integer".equals(string6) : string6 != null) break block6;
                                        dos.writeByte(105);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    String string7 = string2;
                                    if ("logical" != null ? !"logical".equals(string7) : string7 != null) break block7;
                                    dos.writeByte(98);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                String string8 = string2;
                                if ("date" != null ? !"date".equals(string8) : string8 != null) break block8;
                                dos.writeByte(68);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            String string9 = string2;
                            if ("time" != null ? !"time".equals(string9) : string9 != null) break block9;
                            dos.writeByte(116);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        String string10 = string2;
                        if ("raw" != null ? !"raw".equals(string10) : string10 != null) break block10;
                        dos.writeByte(114);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    String string11 = string2;
                    if ("list" != null ? !"list".equals(string11) : string11 != null) break block11;
                    dos.writeByte(108);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                String string12 = string2;
                if ("jobj" != null ? !"jobj".equals(string12) : string12 != null) break block12;
                dos.writeByte(106);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid type ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{typeStr})));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeObject(DataOutputStream dos, Object value2) {
        BoxedUnit boxedUnit;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        block22: {
            block21: {
                if (value2 == null) break block21;
                Object object = value2;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                if (object != null ? !object.equals(boxedUnit2) : boxedUnit2 != null) break block22;
            }
            this.writeType(dos, "void");
            return;
        }
        String string7 = value2.getClass().getName();
        String string8 = string7;
        if ("java.lang.String".equals(string8)) {
            this.writeType(dos, "character");
            this.writeString(dos, (String)value2);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            return;
        }
        String string9 = string7;
        boolean bl = "long".equals(string9) ? true : "java.lang.Long".equals(string6 = string7);
        if (bl) {
            this.writeType(dos, "double");
            this.writeDouble(dos, BoxesRunTime.unboxToLong(value2));
            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
            return;
        }
        String string10 = string7;
        boolean bl2 = "float".equals(string10) ? true : "java.lang.Float".equals(string5 = string7);
        if (bl2) {
            this.writeType(dos, "double");
            this.writeDouble(dos, BoxesRunTime.unboxToFloat(value2));
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
            return;
        }
        String string11 = string7;
        boolean bl3 = "double".equals(string11) ? true : "java.lang.Double".equals(string4 = string7);
        if (bl3) {
            this.writeType(dos, "double");
            this.writeDouble(dos, BoxesRunTime.unboxToDouble(value2));
            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
            return;
        }
        String string12 = string7;
        boolean bl4 = "int".equals(string12) ? true : "java.lang.Integer".equals(string3 = string7);
        if (bl4) {
            this.writeType(dos, "integer");
            this.writeInt(dos, BoxesRunTime.unboxToInt(value2));
            BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
            return;
        }
        String string13 = string7;
        boolean bl5 = "boolean".equals(string13) ? true : "java.lang.Boolean".equals(string2 = string7);
        if (bl5) {
            this.writeType(dos, "logical");
            this.writeBoolean(dos, BoxesRunTime.unboxToBoolean(value2));
            BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
            return;
        }
        String string14 = string7;
        if ("java.sql.Date".equals(string14)) {
            this.writeType(dos, "date");
            this.writeDate(dos, (Date)value2);
            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
            return;
        }
        String string15 = string7;
        if ("java.sql.Time".equals(string15)) {
            this.writeType(dos, "time");
            this.writeTime(dos, (Time)value2);
            BoxedUnit boxedUnit10 = BoxedUnit.UNIT;
            return;
        }
        String string16 = string7;
        if ("java.sql.Timestamp".equals(string16)) {
            this.writeType(dos, "time");
            this.writeTime(dos, (Timestamp)value2);
            BoxedUnit boxedUnit11 = BoxedUnit.UNIT;
            return;
        }
        String string17 = string7;
        if ("[B".equals(string17)) {
            this.writeType(dos, "raw");
            this.writeBytes(dos, (byte[])value2);
            BoxedUnit boxedUnit12 = BoxedUnit.UNIT;
            return;
        }
        String string18 = string7;
        if ("[Ljava.lang.String;".equals(string18)) {
            this.writeType(dos, "list");
            this.writeStringArr(dos, (String[])value2);
            BoxedUnit boxedUnit13 = BoxedUnit.UNIT;
            return;
        }
        String string19 = string7;
        if ("[I".equals(string19)) {
            this.writeType(dos, "list");
            this.writeIntArr(dos, (int[])value2);
            BoxedUnit boxedUnit14 = BoxedUnit.UNIT;
            return;
        }
        String string20 = string7;
        if ("[J".equals(string20)) {
            this.writeType(dos, "list");
            this.writeDoubleArr(dos, (double[])Predef$.MODULE$.longArrayOps((long[])value2).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(long x$9) {
                    return this.apply$mcDJ$sp(x$9);
                }

                public double apply$mcDJ$sp(long x$9) {
                    return x$9;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            BoxedUnit boxedUnit15 = BoxedUnit.UNIT;
            return;
        }
        String string21 = string7;
        if ("[D".equals(string21)) {
            this.writeType(dos, "list");
            this.writeDoubleArr(dos, (double[])value2);
            BoxedUnit boxedUnit16 = BoxedUnit.UNIT;
            return;
        }
        String string22 = string7;
        if ("[Z".equals(string22)) {
            this.writeType(dos, "list");
            this.writeBooleanArr(dos, (boolean[])value2);
            BoxedUnit boxedUnit17 = BoxedUnit.UNIT;
            return;
        }
        String string23 = string7;
        if ("[[B".equals(string23)) {
            this.writeType(dos, "list");
            this.writeBytesArr(dos, (byte[][])value2);
            BoxedUnit boxedUnit18 = BoxedUnit.UNIT;
            return;
        }
        if (string7.startsWith("[L")) {
            Object[] objArr = (Object[])value2;
            this.writeType(dos, "list");
            this.writeType(dos, "jobj");
            dos.writeInt(objArr.length);
            Predef$.MODULE$.refArrayOps(objArr).foreach(new Serializable(dos){
                public static final long serialVersionUID = 0L;
                private final DataOutputStream dos$1;

                public final void apply(Object o) {
                    SerDe$.MODULE$.writeJObj(this.dos$1, o);
                }
                {
                    this.dos$1 = dos$1;
                }
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            this.writeType(dos, "jobj");
            this.writeJObj(dos, value2);
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit19 = boxedUnit;
    }

    public void writeInt(DataOutputStream out, int value2) {
        out.writeInt(value2);
    }

    public void writeDouble(DataOutputStream out, double value2) {
        out.writeDouble(value2);
    }

    public void writeBoolean(DataOutputStream out, boolean value2) {
        out.writeBoolean(value2);
    }

    public void writeDate(DataOutputStream out, Date value2) {
        this.writeString(out, value2.toString());
    }

    public void writeTime(DataOutputStream out, Time value2) {
        out.writeDouble((double)value2.getTime() / 1000.0);
    }

    public void writeTime(DataOutputStream out, Timestamp value2) {
        out.writeDouble((double)(value2.getTime() / 1000L) + (double)value2.getNanos() / 1.0E9);
    }

    public void writeString(DataOutputStream out, String value2) {
        int len = value2.length();
        out.writeInt(len);
        out.writeBytes(value2);
    }

    public void writeBytes(DataOutputStream out, byte[] value2) {
        out.writeInt(value2.length);
        out.write(value2);
    }

    public void writeJObj(DataOutputStream out, Object value2) {
        String objId = JVMObjectTracker$.MODULE$.put(value2);
        this.writeString(out, objId);
    }

    public void writeIntArr(DataOutputStream out, int[] value2) {
        this.writeType(out, "integer");
        out.writeInt(value2.length);
        Predef$.MODULE$.intArrayOps(value2).foreach(new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$2;

            public final void apply(int v) {
                this.apply$mcVI$sp(v);
            }

            public void apply$mcVI$sp(int v) {
                this.out$2.writeInt(v);
            }
            {
                this.out$2 = out$2;
            }
        });
    }

    public void writeDoubleArr(DataOutputStream out, double[] value2) {
        this.writeType(out, "double");
        out.writeInt(value2.length);
        Predef$.MODULE$.doubleArrayOps(value2).foreach(new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$3;

            public final void apply(double v) {
                this.apply$mcVD$sp(v);
            }

            public void apply$mcVD$sp(double v) {
                this.out$3.writeDouble(v);
            }
            {
                this.out$3 = out$3;
            }
        });
    }

    public void writeBooleanArr(DataOutputStream out, boolean[] value2) {
        this.writeType(out, "logical");
        out.writeInt(value2.length);
        Predef$.MODULE$.booleanArrayOps(value2).foreach(new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$4;

            public final void apply(boolean v) {
                SerDe$.MODULE$.writeBoolean(this.out$4, v);
            }
            {
                this.out$4 = out$4;
            }
        });
    }

    public void writeStringArr(DataOutputStream out, String[] value2) {
        this.writeType(out, "character");
        out.writeInt(value2.length);
        Predef$.MODULE$.refArrayOps((Object[])value2).foreach(new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$1;

            public final void apply(String v) {
                SerDe$.MODULE$.writeString(this.out$1, v);
            }
            {
                this.out$1 = out$1;
            }
        });
    }

    public void writeBytesArr(DataOutputStream out, byte[][] value2) {
        this.writeType(out, "raw");
        out.writeInt(value2.length);
        Predef$.MODULE$.refArrayOps((Object[])value2).foreach(new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$5;

            public final void apply(byte[] v) {
                SerDe$.MODULE$.writeBytes(this.out$5, v);
            }
            {
                this.out$5 = out$5;
            }
        });
    }

    private SerDe$() {
        MODULE$ = this;
    }
}

