/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.csharp;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.api.csharp.CSharpBackend;
import org.apache.spark.deploy.PythonRunner$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.csharp.Utils$;
import scala.Console$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileIntRef;
import scala.sys.package$;

public final class CSharpRunner$ {
    public static final CSharpRunner$ MODULE$;

    static {
        new CSharpRunner$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args2) {
        boolean runInDebugMode = false;
        if (args2.length == 0) {
            throw new IllegalArgumentException("At least one argument is expected for CSharpRunner");
        }
        if (args2.length == 1 && args2[0].equalsIgnoreCase("debug")) {
            runInDebugMode = true;
            Predef$.MODULE$.println("[CSharpRunner.main] Debug mode is set. CSharp executable will not be launched as a sub-process.");
        }
        String csharpExecutable = "";
        String[] otherArgs = null;
        if (runInDebugMode) {
            otherArgs = (String[])Predef$.MODULE$.refArrayOps((Object[])args2).slice(1, args2.length);
        } else if (args2[0].toLowerCase().endsWith(".zip")) {
            String zipFileName = args2[0];
            File driverDir = new File("").getAbsoluteFile();
            if (zipFileName.toLowerCase().startsWith("hdfs://")) {
                zipFileName = this.downloadDriverFile(zipFileName, driverDir.getAbsolutePath()).getName();
            }
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[CSharpRunner.main] Unzipping driver ", " in ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{zipFileName, driverDir})));
            Utils$.MODULE$.unzip(new File(zipFileName), driverDir);
            csharpExecutable = PythonRunner$.MODULE$.formatPath(args2[1], PythonRunner$.MODULE$.formatPath$default$2());
            otherArgs = (String[])Predef$.MODULE$.refArrayOps((Object[])args2).slice(2, args2.length);
        } else if (new File(args2[0]).isDirectory()) {
            csharpExecutable = PythonRunner$.MODULE$.formatPath(args2[1], PythonRunner$.MODULE$.formatPath$default$2());
            otherArgs = (String[])Predef$.MODULE$.refArrayOps((Object[])args2).slice(2, args2.length);
        } else {
            csharpExecutable = PythonRunner$.MODULE$.formatPath(args2[0], PythonRunner$.MODULE$.formatPath$default$2());
            otherArgs = (String[])Predef$.MODULE$.refArrayOps((Object[])args2).slice(1, args2.length);
        }
        ObjectRef processParameters = new ObjectRef(new ArrayList());
        ((ArrayList)processParameters.elem).add(csharpExecutable);
        Predef$.MODULE$.refArrayOps((Object[])otherArgs).foreach(new Serializable(processParameters){
            public static final long serialVersionUID = 0L;
            private final ObjectRef processParameters$1;

            public final boolean apply(String arg) {
                return ((ArrayList)this.processParameters$1.elem).add(arg);
            }
            {
                this.processParameters$1 = processParameters$1;
            }
        });
        Predef$.MODULE$.println("[CSharpRunner.main] Starting CSharpBackend!");
        int backendTimeout = new StringOps(Predef$.MODULE$.augmentString(package$.MODULE$.env().getOrElse("CSHARPBACKEND_TIMEOUT", new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "120";
            }
        }))).toInt();
        CSharpBackend csharpBackend = new CSharpBackend();
        VolatileIntRef csharpBackendPortNumber = new VolatileIntRef(0);
        Semaphore initialized = new Semaphore(0);
        Thread csharpBackendThread = new Thread(csharpBackend, csharpBackendPortNumber, initialized){
            private final CSharpBackend csharpBackend$1;
            private final VolatileIntRef csharpBackendPortNumber$1;
            private final Semaphore initialized$1;

            public void run() {
                this.csharpBackendPortNumber$1.elem = this.csharpBackend$1.init();
                Predef$.MODULE$.println(new StringBuilder().append((Object)"[CSharpRunner.main] Port number used by CSharpBackend is ").append(BoxesRunTime.boxToInteger(this.csharpBackendPortNumber$1.elem)).toString());
                this.initialized$1.release();
                this.csharpBackend$1.run();
            }
            {
                this.csharpBackend$1 = csharpBackend$1;
                this.csharpBackendPortNumber$1 = csharpBackendPortNumber$1;
                this.initialized$1 = initialized$1;
                super("CSharpBackend");
            }
        };
        csharpBackendThread.start();
        if (!initialized.tryAcquire(backendTimeout, TimeUnit.SECONDS)) {
            Predef$.MODULE$.println(new StringBuilder().append((Object)"[CSharpRunner.main] CSharpBackend did not initialize in ").append(BoxesRunTime.boxToInteger(backendTimeout)).append((Object)" seconds").toString());
            System.exit(-1);
            return;
        }
        if (runInDebugMode) {
            Predef$.MODULE$.println("***********************************************************************");
            Predef$.MODULE$.println("* [CSharpRunner.main] Backend running debug mode. Press enter to exit *");
            Predef$.MODULE$.println("***********************************************************************");
            Console$.MODULE$.readLine();
            this.closeBackend(csharpBackend);
            System.exit(0);
            return;
        }
        int returnCode = -1;
        try {
            ProcessBuilder builder = new ProcessBuilder((ArrayList)processParameters.elem);
            Map<String, String> env = builder.environment();
            env.put("CSHARPBACKEND_PORT", ((Object)BoxesRunTime.boxToInteger(csharpBackendPortNumber.elem)).toString());
            org.apache.spark.util.Utils$.MODULE$.getSystemProperties().withFilter(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                    Tuple2<String, String> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).withFilter((Function1<Tuple2<String, String>, Object>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> x$1) {
                    Tuple2<String, String> tuple2 = x$1;
                    if (tuple2 != null) {
                        String key = tuple2._1();
                        boolean bl = key.startsWith("spark.");
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            })).foreach(new Serializable(env){
                public static final long serialVersionUID = 0L;
                private final Map env$1;

                public final void apply(Tuple2<String, String> x$2) {
                    Tuple2<String, String> tuple2 = x$2;
                    if (tuple2 != null) {
                        String key = tuple2._1();
                        String value2 = tuple2._2();
                        this.env$1.put(key, value2);
                        Predef$.MODULE$.println(new StringBuilder().append((Object)"[CSharpRunner.main] adding key=").append((Object)key).append((Object)" and value=").append((Object)value2).append((Object)" to environment").toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.env$1 = env$1;
                }
            });
            builder.redirectErrorStream(true);
            Process process2 = builder.start();
            new RedirectThread(process2.getInputStream(), (OutputStream)System.out, "redirect CSharp output", RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            returnCode = process2.waitFor();
            this.closeBackend(csharpBackend);
        }
        catch (Throwable throwable2) {
            Predef$.MODULE$.println(new StringBuilder().append((Object)"[CSharpRunner.main]").append((Object)throwable2.getMessage()).append((Object)"\n").append(throwable2.getStackTrace()).toString());
        }
        Predef$.MODULE$.println(new StringBuilder().append((Object)"[CSharpRunner.main] Return CSharpBackend code ").append(BoxesRunTime.boxToInteger(returnCode)).toString());
        System.exit(returnCode);
    }

    /*
     * WARNING - void declaration
     */
    private File downloadDriverFile(String hdfsFilePath, String driverDir) {
        void var6_6;
        SparkConf sparkConf = new SparkConf();
        Path filePath = new Path(hdfsFilePath);
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(sparkConf);
        String jarFileName = filePath.getName();
        File localFile = new File(driverDir, jarFileName);
        if (!localFile.exists()) {
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copying user file ", " to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{filePath, driverDir})));
            org.apache.spark.util.Utils$.MODULE$.fetchFile(hdfsFilePath, new File(driverDir), sparkConf, new SecurityManager(sparkConf), hadoopConf, System.currentTimeMillis(), false);
        }
        if (localFile.exists()) {
            return localFile;
        }
        throw new Exception(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not see expected ", " in ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{var6_6, driverDir})));
    }

    public void closeBackend(CSharpBackend csharpBackend) {
        Predef$.MODULE$.println("[CSharpRunner.main] closing CSharpBackend");
        csharpBackend.close();
    }

    private CSharpRunner$() {
        MODULE$ = this;
    }
}

