/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.api.csharp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.api.csharp.SerDe$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class SQLUtils$ {
    public static final SQLUtils$ MODULE$;

    static {
        new SQLUtils$();
    }

    public SQLContext createSQLContext(SparkContext sc) {
        return new SQLContext(sc);
    }

    public JavaSparkContext getJavaSparkContext(SQLContext sqlCtx) {
        return new JavaSparkContext(sqlCtx.sparkContext());
    }

    public <T> Seq<T> toSeq(Object arr) {
        return Predef$.MODULE$.genericArrayOps(arr).toSeq();
    }

    public StructType createStructType(Seq<StructField> fields) {
        return StructType$.MODULE$.apply(fields);
    }

    public DataType getSQLDataType(String dataType) {
        block15: {
            ByteType$ byteType$;
            block3: {
                String string2;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block5: {
                                                        block4: {
                                                            block2: {
                                                                String string3 = string2 = dataType;
                                                                if ("byte" != null ? !"byte".equals(string3) : string3 != null) break block2;
                                                                byteType$ = ByteType$.MODULE$;
                                                                break block3;
                                                            }
                                                            String string4 = string2;
                                                            if ("integer" != null ? !"integer".equals(string4) : string4 != null) break block4;
                                                            byteType$ = IntegerType$.MODULE$;
                                                            break block3;
                                                        }
                                                        String string5 = string2;
                                                        if ("float" != null ? !"float".equals(string5) : string5 != null) break block5;
                                                        byteType$ = FloatType$.MODULE$;
                                                        break block3;
                                                    }
                                                    String string6 = string2;
                                                    if ("double" != null ? !"double".equals(string6) : string6 != null) break block6;
                                                    byteType$ = DoubleType$.MODULE$;
                                                    break block3;
                                                }
                                                String string7 = string2;
                                                if ("numeric" != null ? !"numeric".equals(string7) : string7 != null) break block7;
                                                byteType$ = DoubleType$.MODULE$;
                                                break block3;
                                            }
                                            String string8 = string2;
                                            if ("character" != null ? !"character".equals(string8) : string8 != null) break block8;
                                            byteType$ = StringType$.MODULE$;
                                            break block3;
                                        }
                                        String string9 = string2;
                                        if ("string" != null ? !"string".equals(string9) : string9 != null) break block9;
                                        byteType$ = StringType$.MODULE$;
                                        break block3;
                                    }
                                    String string10 = string2;
                                    if ("binary" != null ? !"binary".equals(string10) : string10 != null) break block10;
                                    byteType$ = BinaryType$.MODULE$;
                                    break block3;
                                }
                                String string11 = string2;
                                if ("raw" != null ? !"raw".equals(string11) : string11 != null) break block11;
                                byteType$ = BinaryType$.MODULE$;
                                break block3;
                            }
                            String string12 = string2;
                            if ("logical" != null ? !"logical".equals(string12) : string12 != null) break block12;
                            byteType$ = BooleanType$.MODULE$;
                            break block3;
                        }
                        String string13 = string2;
                        if ("boolean" != null ? !"boolean".equals(string13) : string13 != null) break block13;
                        byteType$ = BooleanType$.MODULE$;
                        break block3;
                    }
                    String string14 = string2;
                    if ("timestamp" != null ? !"timestamp".equals(string14) : string14 != null) break block14;
                    byteType$ = TimestampType$.MODULE$;
                    break block3;
                }
                String string15 = string2;
                if ("date" != null ? !"date".equals(string15) : string15 != null) break block15;
                byteType$ = DateType$.MODULE$;
            }
            return byteType$;
        }
        throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invaid type ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{dataType})));
    }

    public StructField createStructField(String name, String dataType, boolean nullable) {
        DataType dtObj = this.getSQLDataType(dataType);
        return new StructField(name, dtObj, nullable, StructField$.MODULE$.apply$default$4());
    }

    public DataFrame createDF(RDD<byte[]> rdd, StructType schema, SQLContext sqlContext) {
        int num = Predef$.MODULE$.refArrayOps((Object[])schema.fields()).size();
        RDD rowRDD = rdd.map((Function1)((Object)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final Row apply(byte[] x$1) {
                return SQLUtils$.MODULE$.org$apache$spark$sql$api$csharp$SQLUtils$$bytesToRow(x$1, this.schema$1);
            }
            {
                this.schema$1 = schema$1;
            }
        }), ClassTag$.MODULE$.apply(Row.class));
        return sqlContext.createDataFrame(rowRDD, schema);
    }

    public RDD<byte[]> dfToRowRDD(DataFrame df) {
        return df.map((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Row r) {
                return SQLUtils$.MODULE$.org$apache$spark$sql$api$csharp$SQLUtils$$rowToCSharpBytes(r);
            }
        }), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object org$apache$spark$sql$api$csharp$SQLUtils$$doConversion(Object data2, DataType dataType) {
        Object object = data2;
        if (!(object instanceof Double)) return data2;
        Double d = (Double)object;
        DataType dataType2 = dataType;
        FloatType$ floatType$ = FloatType$.MODULE$;
        if (dataType2 != null) {
            if (!dataType2.equals(floatType$)) return data2;
            return new Float(Predef$.MODULE$.Double2double(d));
        }
        if (floatType$ == null) return new Float(Predef$.MODULE$.Double2double(d));
        return data2;
    }

    public Row org$apache$spark$sql$api$csharp$SQLUtils$$bytesToRow(byte[] bytes2, StructType schema) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes2);
        DataInputStream dis = new DataInputStream(bis);
        int num = SerDe$.MODULE$.readInt(dis);
        return Row$.MODULE$.fromSeq(((scala.collection.immutable.Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), num).map(new Serializable(schema, dis){
            public static final long serialVersionUID = 0L;
            private final StructType schema$2;
            private final DataInputStream dis$1;

            public final Object apply(int i) {
                return SQLUtils$.MODULE$.org$apache$spark$sql$api$csharp$SQLUtils$$doConversion(SerDe$.MODULE$.readObject(this.dis$1), this.schema$2.fields()[i].dataType());
            }
            {
                this.schema$2 = schema$2;
                this.dis$1 = dis$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
    }

    public byte[] org$apache$spark$sql$api$csharp$SQLUtils$$rowToCSharpBytes(Row row) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        SerDe$.MODULE$.writeInt(dos, row.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.length()).map(new Serializable(row, dos){
            public static final long serialVersionUID = 0L;
            private final Row row$1;
            private final DataOutputStream dos$1;

            public final void apply(int idx) {
                this.apply$mcVI$sp(idx);
            }

            public void apply$mcVI$sp(int idx) {
                Object obj = this.row$1.apply(idx);
                SerDe$.MODULE$.writeObject(this.dos$1, obj);
            }
            {
                this.row$1 = row$1;
                this.dos$1 = dos$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return bos.toByteArray();
    }

    public byte[][] dfToCols(DataFrame df) {
        Row[] localDF = df.collect();
        int numCols = df.columns().length;
        Object[][] dfCols = this.convertRowsToColumns(localDF, numCols);
        return (byte[][])Predef$.MODULE$.refArrayOps((Object[])dfCols).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Object[] col) {
                return SQLUtils$.MODULE$.colToCSharpBytes(col);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
    }

    public Object[][] convertRowsToColumns(Row[] localDF, int numCols) {
        return (Object[][])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numCols).map(new Serializable(localDF){
            public static final long serialVersionUID = 0L;
            private final Row[] localDF$1;

            public final Object[] apply(int colIdx) {
                return (Object[])Predef$.MODULE$.refArrayOps((Object[])this.localDF$1).map(new Serializable(this, colIdx){
                    public static final long serialVersionUID = 0L;
                    private final int colIdx$1;

                    public final Object apply(Row row) {
                        return row.apply(this.colIdx$1);
                    }
                    {
                        this.colIdx$1 = colIdx$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
            }
            {
                this.localDF$1 = localDF$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
    }

    public byte[] colToCSharpBytes(Object[] col) {
        int numRows = col.length;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        SerDe$.MODULE$.writeInt(dos, numRows);
        Predef$.MODULE$.genericArrayOps(col).map(new Serializable(dos){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream dos$2;

            public final void apply(Object item) {
                Object obj = item;
                SerDe$.MODULE$.writeObject(this.dos$2, obj);
            }
            {
                this.dos$2 = dos$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
        return bos.toByteArray();
    }

    public SaveMode saveMode(String mode) {
        String string2;
        block6: {
            SaveMode saveMode;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            String string3 = string2 = mode;
                            if ("append" != null ? !"append".equals(string3) : string3 != null) break block2;
                            saveMode = SaveMode.Append;
                            break block3;
                        }
                        String string4 = string2;
                        if ("overwrite" != null ? !"overwrite".equals(string4) : string4 != null) break block4;
                        saveMode = SaveMode.Overwrite;
                        break block3;
                    }
                    String string5 = string2;
                    if ("error" != null ? !"error".equals(string5) : string5 != null) break block5;
                    saveMode = SaveMode.ErrorIfExists;
                    break block3;
                }
                String string6 = string2;
                if ("ignore" != null ? !"ignore".equals(string6) : string6 != null) break block6;
                saveMode = SaveMode.Ignore;
            }
            return saveMode;
        }
        throw new MatchError((Object)string2);
    }

    public DataFrame loadDF(SQLContext sqlContext, String source, Map<String, String> options) {
        return sqlContext.read().format(source).options(options).load();
    }

    public DataFrame loadDF(SQLContext sqlContext, String source, StructType schema, Map<String, String> options) {
        return sqlContext.read().format(source).schema(schema).options(options).load();
    }

    public DataFrame loadDF(SQLContext sqlContext, String source, StructType schema) {
        return sqlContext.read().format(source).schema(schema).load();
    }

    public DataFrame loadTextFile(SQLContext sqlContext, String path, Boolean hasHeader, Boolean inferSchema) {
        DataFrameReader dfReader = sqlContext.read().format("com.databricks.spark.csv");
        if (Predef$.MODULE$.Boolean2boolean(hasHeader)) {
            dfReader = dfReader.option("header", "true");
        }
        if (Predef$.MODULE$.Boolean2boolean(inferSchema)) {
            dfReader = dfReader.option("inferSchema", "true");
        }
        return dfReader.load(path);
    }

    public DataFrame loadTextFile(SQLContext sqlContext, String path, String delimiter, StructType schema) {
        RDD stringRdd = sqlContext.sparkContext().textFile(path, sqlContext.sparkContext().textFile$default$2());
        RDD rowRdd = stringRdd.map((Function1)((Object)new Serializable(delimiter){
            public static final long serialVersionUID = 0L;
            private final String delimiter$1;

            public final Row apply(String s2) {
                Row row;
                String[] columns = s2.split(this.delimiter$1);
                int n = columns.length;
                switch (n) {
                    default: {
                        throw new Exception("Text files with more than 30 columns currently not supported");
                    }
                    case 30: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17], columns[18], columns[19], columns[20], columns[21], columns[22], columns[23], columns[24], columns[25], columns[26], columns[27], columns[28], columns[29]});
                        break;
                    }
                    case 29: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17], columns[18], columns[19], columns[20], columns[21], columns[22], columns[23], columns[24], columns[25], columns[26], columns[27], columns[28]});
                        break;
                    }
                    case 28: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17], columns[18], columns[19], columns[20], columns[21], columns[22], columns[23], columns[24], columns[25], columns[26], columns[27]});
                        break;
                    }
                    case 27: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17], columns[18], columns[19], columns[20], columns[21], columns[22], columns[23], columns[24], columns[25], columns[26]});
                        break;
                    }
                    case 26: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17], columns[18], columns[19], columns[20], columns[21], columns[22], columns[23], columns[24], columns[25]});
                        break;
                    }
                    case 25: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17], columns[18], columns[19], columns[20], columns[21], columns[22], columns[23], columns[24]});
                        break;
                    }
                    case 24: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17], columns[18], columns[19], columns[20], columns[21], columns[22], columns[23]});
                        break;
                    }
                    case 23: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17], columns[18], columns[19], columns[20], columns[21], columns[22]});
                        break;
                    }
                    case 22: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17], columns[18], columns[19], columns[20], columns[21]});
                        break;
                    }
                    case 21: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17], columns[18], columns[19], columns[20]});
                        break;
                    }
                    case 20: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17], columns[18], columns[19]});
                        break;
                    }
                    case 19: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17], columns[18]});
                        break;
                    }
                    case 18: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16], columns[17]});
                        break;
                    }
                    case 17: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15], columns[16]});
                        break;
                    }
                    case 16: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14], columns[15]});
                        break;
                    }
                    case 15: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13], columns[14]});
                        break;
                    }
                    case 14: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12], columns[13]});
                        break;
                    }
                    case 13: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11], columns[12]});
                        break;
                    }
                    case 12: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10], columns[11]});
                        break;
                    }
                    case 11: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9], columns[10]});
                        break;
                    }
                    case 10: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8], columns[9]});
                        break;
                    }
                    case 9: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7], columns[8]});
                        break;
                    }
                    case 8: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6], columns[7]});
                        break;
                    }
                    case 7: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5], columns[6]});
                        break;
                    }
                    case 6: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4], columns[5]});
                        break;
                    }
                    case 5: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3], columns[4]});
                        break;
                    }
                    case 4: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2], columns[3]});
                        break;
                    }
                    case 3: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1], columns[2]});
                        break;
                    }
                    case 2: {
                        row = RowFactory.create((Object[])new Object[]{columns[0], columns[1]});
                        break;
                    }
                    case 1: {
                        row = RowFactory.create((Object[])new Object[]{columns[0]});
                    }
                }
                return row;
            }
            {
                this.delimiter$1 = delimiter$1;
            }
        }), ClassTag$.MODULE$.apply(Row.class));
        return sqlContext.createDataFrame(rowRdd, schema);
    }

    private SQLUtils$() {
        MODULE$ = this;
    }
}

