/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.csharp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Utils$ {
    public static final Utils$ MODULE$;

    static {
        new Utils$();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> listZipFileEntries(File file) {
        void var2_2;
        ArrayBuffer result2 = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                result2.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{entries.nextElement().getName()}));
            }
        }
        catch (Throwable throwable2) {
            void var3_3;
            var3_3.close();
            throw throwable2;
        }
        zipFile.close();
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void zip(File sourceDir, File targetZipFile) {
        if (!sourceDir.exists() || !sourceDir.isDirectory()) return;
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(targetZipFile);
            zos = new ZipOutputStream(fos);
            this.org$apache$spark$util$csharp$Utils$$zipDir(sourceDir, sourceDir, zos);
        }
        catch (Exception exception) {
            try {
                throw exception;
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(zos);
                IOUtils.closeQuietly((OutputStream)fos);
                throw throwable2;
            }
        }
        IOUtils.closeQuietly((OutputStream)zos);
        IOUtils.closeQuietly((OutputStream)fos);
        return;
    }

    public void org$apache$spark$util$csharp$Utils$$zipDir(File rootDir, File sourceDir, ZipOutputStream out) {
        Predef$.MODULE$.refArrayOps((Object[])sourceDir.listFiles()).foreach(new Serializable(rootDir, sourceDir, out){
            public static final long serialVersionUID = 0L;
            private final File rootDir$1;
            private final File sourceDir$1;
            private final ZipOutputStream out$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(File file) {
                java.io.Serializable serializable2;
                if (file.isDirectory()) {
                    Utils$.MODULE$.org$apache$spark$util$csharp$Utils$$zipDir(this.rootDir$1, new File(this.sourceDir$1, file.getName()), this.out$1);
                    serializable2 = BoxedUnit.UNIT;
                    return serializable2;
                }
                FileInputStream in = null;
                try {
                    ZipEntry entry2 = new ZipEntry(file.getPath().substring(this.rootDir$1.getPath().length() + 1));
                    this.out$1.putNextEntry(entry2);
                    in = new FileInputStream(file);
                    serializable2 = BoxesRunTime.boxToInteger(IOUtils.copy((InputStream)in, (OutputStream)this.out$1));
                }
                catch (Throwable throwable2) {
                    IOUtils.closeQuietly(in);
                    throw throwable2;
                }
                IOUtils.closeQuietly((InputStream)in);
                return serializable2;
            }
            {
                this.rootDir$1 = rootDir$1;
                this.sourceDir$1 = sourceDir$1;
                this.out$1 = out$1;
            }
        });
    }

    public void unzip(File file, File targetDir) {
        java.io.Serializable serializable2 = targetDir.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean(targetDir.mkdir());
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                java.io.Serializable serializable3;
                ZipEntry entry2 = entries.nextElement();
                File targetFile = new File(targetDir, entry2.getName());
                java.io.Serializable serializable4 = targetFile.getParentFile().exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean(targetFile.getParentFile().mkdir());
                if (entry2.isDirectory()) {
                    serializable3 = BoxesRunTime.boxToBoolean(targetFile.mkdirs());
                    continue;
                }
                InputStream input2 = zipFile.getInputStream(entry2);
                FileOutputStream output = new FileOutputStream(targetFile);
                IOUtils.copy((InputStream)input2, (OutputStream)output);
                IOUtils.closeQuietly((InputStream)input2);
                IOUtils.closeQuietly((OutputStream)output);
                serializable3 = BoxedUnit.UNIT;
            }
            return;
        }
        finally {
            zipFile.close();
        }
    }

    private Utils$() {
        MODULE$ = this;
    }
}

