/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool.helpers;

import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import scala.actors.threadpool.Arrays;
import scala.actors.threadpool.Perf;
import scala.actors.threadpool.TimeUnit;
import scala.actors.threadpool.helpers.NanoTimer;
import scala.actors.threadpool.locks.Condition;

public final class Utils {
    private static final NanoTimer nanoTimer;
    private static final String providerProp = "edu.emory.mathcs.backport.java.util.concurrent.NanoTimerProvider";

    private Utils() {
    }

    public static long nanoTime() {
        return nanoTimer.nanoTime();
    }

    public static long awaitNanos(Condition cond, long nanosTimeout) throws InterruptedException {
        if (nanosTimeout <= 0L) {
            return nanosTimeout;
        }
        long now = Utils.nanoTime();
        cond.await(nanosTimeout, TimeUnit.NANOSECONDS);
        return nanosTimeout - (Utils.nanoTime() - now);
    }

    private static long gcd(long a, long b) {
        while (b > 0L) {
            long r = a % b;
            a = b;
            b = r;
        }
        return a;
    }

    public static Object[] collectionToArray(Collection c) {
        int len = c.size();
        Object[] arr = new Object[len];
        Iterator itr = c.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
                continue;
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                return Arrays.copyOf(arr, idx, Object[].class);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            arr = Arrays.copyOf(arr, newcap, Object[].class);
            len = newcap;
        }
    }

    public static Object[] collectionToArray(Collection c, Object[] a) {
        Class<?> aType = a.getClass();
        int len = c.size();
        Object[] arr = a.length >= len ? a : (Object[])Array.newInstance(aType.getComponentType(), len);
        Iterator itr = c.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
                continue;
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                if (arr == a) {
                    a[idx] = null;
                    return a;
                }
                return Arrays.copyOf(arr, idx, aType);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            arr = Arrays.copyOf(arr, newcap, aType);
            len = newcap;
        }
    }

    static {
        NanoTimer timer = null;
        try {
            String nanoTimerClassName = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(Utils.providerProp);
                }
            });
            if (nanoTimerClassName != null) {
                Class<?> cls = Class.forName(nanoTimerClassName);
                timer = (NanoTimer)cls.newInstance();
            }
        }
        catch (Exception e) {
            System.err.println("WARNING: unable to load the system-property-defined nanotime provider; switching to the default");
            e.printStackTrace();
        }
        if (timer == null) {
            try {
                timer = new SunPerfProvider();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        if (timer == null) {
            timer = new MillisProvider();
        }
        nanoTimer = timer;
    }

    private static final class MillisProvider
    implements NanoTimer {
        MillisProvider() {
        }

        @Override
        public long nanoTime() {
            return System.currentTimeMillis() * 1000000L;
        }
    }

    private static final class SunPerfProvider
    implements NanoTimer {
        final Perf perf = AccessController.doPrivileged(new PrivilegedAction<Perf>(){

            @Override
            public Perf run() {
                return Perf.getPerf();
            }
        });
        final long multiplier;
        final long divisor;

        SunPerfProvider() {
            long numerator = 1000000000L;
            long denominator = this.perf.highResFrequency();
            long gcd = Utils.gcd(numerator, denominator);
            this.multiplier = numerator / gcd;
            this.divisor = denominator / gcd;
        }

        @Override
        public long nanoTime() {
            long ctr = this.perf.highResCounter();
            return ctr / this.divisor * this.multiplier + ctr % this.divisor * this.multiplier / this.divisor;
        }
    }
}

