/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.common;

import java.beans.ConstructorProperties;
import org.apache.tinkerpop.gremlin.driver.ser.Serializers;

public class GremlinConfig {
    private String endpoint;
    private int port;
    private String username;
    private String password;
    private boolean sslEnabled;
    private boolean telemetryAllowed;
    private String serializer;

    public static GremlinConfigBuilder builder(String endpoint, String username, String password) {
        return GremlinConfig.defaultBuilder().endpoint(endpoint).username(username).password(password).port(443).sslEnabled(true).serializer(Serializers.GRAPHSON.toString()).telemetryAllowed(true);
    }

    public static GremlinConfigBuilder defaultBuilder() {
        return new GremlinConfigBuilder();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public boolean isTelemetryAllowed() {
        return this.telemetryAllowed;
    }

    public String getSerializer() {
        return this.serializer;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public void setTelemetryAllowed(boolean telemetryAllowed) {
        this.telemetryAllowed = telemetryAllowed;
    }

    public void setSerializer(String serializer) {
        this.serializer = serializer;
    }

    @ConstructorProperties(value={"endpoint", "port", "username", "password", "sslEnabled", "telemetryAllowed", "serializer"})
    public GremlinConfig(String endpoint, int port, String username, String password, boolean sslEnabled, boolean telemetryAllowed, String serializer) {
        this.endpoint = endpoint;
        this.port = port;
        this.username = username;
        this.password = password;
        this.sslEnabled = sslEnabled;
        this.telemetryAllowed = telemetryAllowed;
        this.serializer = serializer;
    }

    public static class GremlinConfigBuilder {
        private String endpoint;
        private int port;
        private String username;
        private String password;
        private boolean sslEnabled;
        private boolean telemetryAllowed;
        private String serializer;

        GremlinConfigBuilder() {
        }

        public GremlinConfigBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public GremlinConfigBuilder port(int port) {
            this.port = port;
            return this;
        }

        public GremlinConfigBuilder username(String username) {
            this.username = username;
            return this;
        }

        public GremlinConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        public GremlinConfigBuilder sslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public GremlinConfigBuilder telemetryAllowed(boolean telemetryAllowed) {
            this.telemetryAllowed = telemetryAllowed;
            return this;
        }

        public GremlinConfigBuilder serializer(String serializer) {
            this.serializer = serializer;
            return this;
        }

        public GremlinConfig build() {
            return new GremlinConfig(this.endpoint, this.port, this.username, this.password, this.sslEnabled, this.telemetryAllowed, this.serializer);
        }

        public String toString() {
            return "GremlinConfig.GremlinConfigBuilder(endpoint=" + this.endpoint + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + ", sslEnabled=" + this.sslEnabled + ", telemetryAllowed=" + this.telemetryAllowed + ", serializer=" + this.serializer + ")";
        }
    }
}

