/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.source;

import com.microsoft.spring.data.gremlin.common.GremlinUtils;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.exception.GremlinEntityInformationException;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedEntityTypeException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Date;
import lombok.NonNull;
import org.apache.tinkerpop.shaded.jackson.databind.JavaType;
import org.apache.tinkerpop.shaded.jackson.databind.type.TypeFactory;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractGremlinSourceReader {
    protected Object readProperty(@NonNull PersistentProperty property, @Nullable Object value) {
        Object object;
        if (property == null) {
            throw new NullPointerException("property");
        }
        Class type = property.getTypeInformation().getType();
        JavaType javaType = TypeFactory.defaultInstance().constructType((Type)property.getType());
        if (value == null) {
            return null;
        }
        if (type == Integer.TYPE || type == Integer.class || type == Boolean.class || type == Boolean.TYPE || type == String.class) {
            return value;
        }
        if (type == Date.class) {
            Assert.isTrue((boolean)(value instanceof Long), (String)"Date store value must be instance of long");
            return new Date((Long)value);
        }
        try {
            object = GremlinUtils.getObjectMapper().readValue(value.toString(), javaType);
        }
        catch (IOException e) {
            throw new GremlinUnexpectedEntityTypeException("Failed to read String to Object", e);
        }
        return object;
    }

    protected Object getGremlinSourceId(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!source.getId().isPresent()) {
            return null;
        }
        Object id = source.getId().get();
        Field idField = source.getIdField();
        if (idField.getType() == String.class) {
            return id.toString();
        }
        if (idField.getType() == Integer.class) {
            Assert.isTrue((boolean)(id instanceof Integer), (String)"source Id should be Integer.");
            return id;
        }
        if (idField.getType() == Long.class && id instanceof Integer) {
            return (long)((Integer)id).intValue();
        }
        if (idField.getType() == Long.class && id instanceof Long) {
            return id;
        }
        throw new GremlinEntityInformationException("unsupported id field type: " + id.getClass().getSimpleName());
    }
}

