/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.source;

import com.microsoft.spring.data.gremlin.annotation.EdgeFrom;
import com.microsoft.spring.data.gremlin.annotation.EdgeTo;
import com.microsoft.spring.data.gremlin.conversion.MappingGremlinConverter;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceEdge;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceWriter;
import com.microsoft.spring.data.gremlin.exception.GremlinEntityInformationException;
import com.microsoft.spring.data.gremlin.exception.GremlinInvalidEntityIdFieldException;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedEntityTypeException;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import com.microsoft.spring.data.gremlin.mapping.GremlinPersistentEntity;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.lang.NonNull;

public class GremlinSourceEdgeWriter
implements GremlinSourceWriter {
    private Object getIdValue(@NonNull Object object, @NonNull MappingGremlinConverter converter) {
        if (object instanceof String || object instanceof Long || object instanceof Integer) {
            return object;
        }
        if (object.getClass().isPrimitive()) {
            throw new GremlinUnexpectedEntityTypeException("only String type of primitive is allowed");
        }
        return converter.getIdFieldValue(object);
    }

    @Override
    public void write(@NonNull Object domain, @NonNull MappingGremlinConverter converter, @NonNull GremlinSource source) throws GremlinInvalidEntityIdFieldException {
        if (!(source instanceof GremlinSourceEdge)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceEdge");
        }
        source.setId(converter.getIdFieldValue(domain));
        GremlinSourceEdge sourceEdge = (GremlinSourceEdge)source;
        GremlinPersistentEntity<?> persistentEntity = converter.getPersistentEntity(domain.getClass());
        ConvertingPropertyAccessor accessor = converter.getPropertyAccessor(domain);
        for (Field field : FieldUtils.getAllFields(domain.getClass())) {
            Object vertexId;
            PersistentProperty property = persistentEntity.getPersistentProperty(field.getName());
            if (property == null) continue;
            Object object = accessor.getProperty(property);
            if (field.getName().equals("id") || field.getAnnotation(Id.class) != null) continue;
            if (field.getName().equals("_classname")) {
                throw new GremlinEntityInformationException("Domain Cannot use pre-defined field name: _classname");
            }
            if (field.getAnnotation(EdgeFrom.class) != null) {
                vertexId = this.getIdValue(object, converter);
                if (vertexId == null) {
                    throw new GremlinInvalidEntityIdFieldException("The vertex id for the from vertex cannot be null!");
                }
                sourceEdge.setVertexIdFrom(vertexId);
            } else if (field.getAnnotation(EdgeTo.class) != null) {
                vertexId = this.getIdValue(object, converter);
                if (vertexId == null) {
                    throw new GremlinInvalidEntityIdFieldException("The vertex id for the to vertex cannot be null!");
                }
                sourceEdge.setVertexIdTo(vertexId);
            }
            source.setProperty(field.getName(), accessor.getProperty(property));
        }
    }
}

