/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.source;

import com.microsoft.spring.data.gremlin.annotation.EdgeSet;
import com.microsoft.spring.data.gremlin.annotation.VertexSet;
import com.microsoft.spring.data.gremlin.common.GremlinUtils;
import com.microsoft.spring.data.gremlin.conversion.MappingGremlinConverter;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceGraph;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceWriter;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import com.microsoft.spring.data.gremlin.mapping.GremlinPersistentEntity;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class GremlinSourceGraphWriter
implements GremlinSourceWriter {
    private void writeGraphSet(@NonNull List<Object> objectList, @NonNull MappingGremlinConverter mappingConverter, @NonNull GremlinSourceGraph sourceGraph) {
        Assert.isInstanceOf(GremlinSourceGraph.class, (Object)sourceGraph, (String)"should be instance of GremlinSourceGraph ");
        for (Object object : objectList) {
            GremlinSource<?> source = GremlinUtils.toGremlinSource(object.getClass());
            source.doGremlinSourceWrite(object, mappingConverter);
            sourceGraph.addGremlinSource(source);
        }
    }

    @Override
    public void write(@NonNull Object domain, @NonNull MappingGremlinConverter converter, @NonNull GremlinSource source) {
        if (!(source instanceof GremlinSourceGraph)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceEdge");
        }
        GremlinSourceGraph sourceGraph = (GremlinSourceGraph)source;
        GremlinPersistentEntity<?> persistentEntity = converter.getPersistentEntity(domain.getClass());
        ConvertingPropertyAccessor accessor = converter.getPropertyAccessor(domain);
        for (Field field : FieldUtils.getAllFields(domain.getClass())) {
            PersistentProperty property = persistentEntity.getPersistentProperty(field.getName());
            if (property == null || field.getName().equals("id") || field.getAnnotation(Id.class) != null) continue;
            List objects = (List)accessor.getProperty(property);
            if (field.getAnnotation(VertexSet.class) == null && field.getAnnotation(EdgeSet.class) == null) continue;
            this.writeGraphSet(objects, converter, sourceGraph);
        }
    }
}

