/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.query.query;

import com.microsoft.spring.data.gremlin.query.GremlinOperations;
import com.microsoft.spring.data.gremlin.query.paramerter.GremlinParameterAccessor;
import com.microsoft.spring.data.gremlin.query.paramerter.GremlinParametersParameterAccessor;
import com.microsoft.spring.data.gremlin.query.query.GremlinQuery;
import com.microsoft.spring.data.gremlin.query.query.GremlinQueryExecution;
import com.microsoft.spring.data.gremlin.query.query.GremlinQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.lang.NonNull;

public abstract class AbstractGremlinQuery
implements RepositoryQuery {
    private final GremlinQueryMethod method;
    private final GremlinOperations operations;

    public AbstractGremlinQuery(@NonNull GremlinQueryMethod method, @NonNull GremlinOperations operations) {
        this.method = method;
        this.operations = operations;
    }

    protected abstract GremlinQuery createQuery(GremlinParameterAccessor var1);

    protected boolean isDeleteQuery() {
        return false;
    }

    public Object execute(@NonNull Object[] parameters) {
        GremlinParametersParameterAccessor accessor = new GremlinParametersParameterAccessor(this.method, parameters);
        GremlinQuery query = this.createQuery(accessor);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        GremlinQueryExecution execution = this.getExecution();
        return execution.execute(query, processor.getReturnedType().getDomainType());
    }

    @NonNull
    public GremlinQueryMethod getQueryMethod() {
        return this.method;
    }

    @NonNull
    private GremlinQueryExecution getExecution() {
        if (this.isDeleteQuery()) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        return new GremlinQueryExecution.FindExecution(this.operations);
    }
}

