/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.result;

import com.microsoft.spring.data.gremlin.conversion.result.AbstractGremlinResultReader;
import com.microsoft.spring.data.gremlin.conversion.result.GremlinResultEdgeReader;
import com.microsoft.spring.data.gremlin.conversion.result.GremlinResultVertexReader;
import com.microsoft.spring.data.gremlin.conversion.result.GremlinResultsReader;
import com.microsoft.spring.data.gremlin.conversion.source.AbstractGremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceEdge;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceGraph;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceVertex;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedEntityTypeException;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class GremlinResultsGraphReader
extends AbstractGremlinResultReader
implements GremlinResultsReader {
    private final GremlinResultVertexReader vertexResultReader = new GremlinResultVertexReader();
    private final GremlinResultEdgeReader edgeResultReader = new GremlinResultEdgeReader();

    @Override
    public void read(@NonNull List<Result> results, @NonNull GremlinSource source) {
        if (!(source instanceof GremlinSourceGraph)) {
            throw new GremlinUnexpectedSourceTypeException("Should be instance of GremlinSourceGraph");
        }
        GremlinSourceGraph graphSource = (GremlinSourceGraph)source;
        graphSource.getVertexSet().clear();
        graphSource.getEdgeSet().clear();
        results.stream().map(this::processResult).forEach(graphSource::addGremlinSource);
    }

    private GremlinSource processResult(Result result) {
        AbstractGremlinSource source;
        String type;
        Object obj = result.getObject();
        Assert.isInstanceOf(Map.class, (Object)obj, (String)"should be an instance of Map");
        Map map = (Map)result.getObject();
        Assert.isTrue((boolean)map.containsKey("type"), (String)"should contain a type property");
        switch (type = (String)map.get("type")) {
            case "vertex": {
                source = new GremlinSourceVertex();
                this.vertexResultReader.read(Collections.singletonList(result), source);
                break;
            }
            case "edge": {
                source = new GremlinSourceEdge();
                this.edgeResultReader.read(Collections.singletonList(result), source);
                break;
            }
            default: {
                throw new GremlinUnexpectedEntityTypeException("Unexpected result type: " + type);
            }
        }
        return source;
    }
}

