/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.source;

import com.microsoft.spring.data.gremlin.annotation.GeneratedValue;
import com.microsoft.spring.data.gremlin.conversion.MappingGremlinConverter;
import com.microsoft.spring.data.gremlin.conversion.result.GremlinResultsReader;
import com.microsoft.spring.data.gremlin.conversion.script.GremlinScriptLiteral;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceReader;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceWriter;
import com.microsoft.spring.data.gremlin.exception.GremlinInvalidEntityIdFieldException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class AbstractGremlinSource<T>
implements GremlinSource<T> {
    private Object id;
    private String label;
    private Field idField;
    private Class<T> domainClass;
    private Map<String, Object> properties;
    private GremlinScriptLiteral scriptLiteral;
    private GremlinSourceWriter sourceWriter;
    private GremlinSourceReader sourceReader;
    private GremlinResultsReader resultReader;

    protected AbstractGremlinSource() {
        this.properties = new HashMap<String, Object>();
    }

    protected AbstractGremlinSource(Class<T> domainClass) {
        this.domainClass = domainClass;
        this.properties = new HashMap<String, Object>();
        this.setProperty("_classname", domainClass.getName());
    }

    @Override
    public Optional<Object> getId() {
        return Optional.ofNullable(this.id);
    }

    @Override
    public void setId(Object id) {
        Field idField = this.getIdField();
        if (idField == null) {
            throw new GremlinInvalidEntityIdFieldException("Id Field of GremlinSource cannot be null");
        }
        if (idField.isAnnotationPresent(GeneratedValue.class) && id instanceof String) {
            try {
                this.id = Long.valueOf((String)id);
            }
            catch (NumberFormatException ignore) {
                this.id = id;
            }
        } else {
            this.id = id;
        }
    }

    @Override
    public void setGremlinScriptStrategy(@NonNull GremlinScriptLiteral script) {
        this.setScriptLiteral(script);
    }

    @Override
    public void setGremlinSourceWriter(@NonNull GremlinSourceWriter writer) {
        this.setSourceWriter(writer);
    }

    @Override
    public void setGremlinSourceReader(@NonNull GremlinSourceReader reader) {
        this.setSourceReader(reader);
    }

    @Override
    public void setGremlinResultReader(@NonNull GremlinResultsReader reader) {
        this.setResultReader(reader);
    }

    @Override
    public GremlinScriptLiteral getGremlinScriptLiteral() {
        return this.scriptLiteral;
    }

    @Override
    public void doGremlinSourceWrite(@NonNull Object domain, @NonNull MappingGremlinConverter converter) {
        Assert.notNull((Object)this.sourceWriter, (String)"the sourceWriter must be set before do writing");
        this.sourceWriter.write(domain, converter, this);
    }

    @Override
    public T doGremlinSourceRead(@NonNull Class<T> domainClass, @NonNull MappingGremlinConverter converter) {
        Assert.notNull((Object)this.sourceReader, (String)"the sourceReader must be set before do reading");
        return this.sourceReader.read(domainClass, converter, this);
    }

    @Override
    public void doGremlinResultRead(@NonNull List<Result> results) {
        Assert.notNull((Object)this.resultReader, (String)"the resultReader must be set before do reading");
        this.resultReader.read(results, this);
    }

    private boolean hasProperty(String key) {
        return this.properties.get(key) != null;
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.hasProperty(key) && value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Field getIdField() {
        return this.idField;
    }

    @Override
    public void setIdField(Field idField) {
        this.idField = idField;
    }

    @Override
    public Class<T> getDomainClass() {
        return this.domainClass;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    private void setScriptLiteral(GremlinScriptLiteral scriptLiteral) {
        this.scriptLiteral = scriptLiteral;
    }

    private void setSourceWriter(GremlinSourceWriter sourceWriter) {
        this.sourceWriter = sourceWriter;
    }

    private void setSourceReader(GremlinSourceReader sourceReader) {
        this.sourceReader = sourceReader;
    }

    private void setResultReader(GremlinResultsReader resultReader) {
        this.resultReader = resultReader;
    }
}

