/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.common;

import com.microsoft.spring.data.gremlin.annotation.GeneratedValue;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.exception.GremlinIllegalConfigurationException;
import com.microsoft.spring.data.gremlin.exception.GremlinInvalidEntityIdFieldException;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import com.microsoft.spring.data.gremlin.repository.support.GremlinEntityInformation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.tinkerpop.shaded.jackson.databind.MapperFeature;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.springframework.data.annotation.Id;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class GremlinUtils {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static <T> T createInstance(@NonNull Class<T> type) {
        T instance;
        try {
            instance = type.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("can not access type constructor", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("failed to create instance of given type", e);
        }
        return instance;
    }

    public static <T> Field getIdField(@NonNull Class<T> domainClass) {
        Field idField;
        List idFields = FieldUtils.getFieldsListWithAnnotation(domainClass, Id.class);
        List generatedValueFields = FieldUtils.getFieldsListWithAnnotation(domainClass, GeneratedValue.class);
        if (generatedValueFields.size() > 1) {
            throw new GremlinIllegalConfigurationException("Only one field, the id field, can have the optional @GeneratedValue annotation!");
        }
        if (idFields.isEmpty()) {
            idField = ReflectionUtils.findField(domainClass, (String)"id");
        } else if (idFields.size() == 1) {
            idField = (Field)idFields.get(0);
        } else {
            throw new GremlinInvalidEntityIdFieldException("only one @Id field is allowed");
        }
        if (idField == null) {
            throw new GremlinInvalidEntityIdFieldException("no field named id in class");
        }
        if (idField.getType() != String.class && idField.getType() != Long.class && idField.getType() != Integer.class) {
            throw new GremlinInvalidEntityIdFieldException("the type of @Id/id field should be String/Integer/Long");
        }
        if (generatedValueFields.size() == 1 && !((Field)generatedValueFields.get(0)).equals(idField)) {
            throw new GremlinIllegalConfigurationException("Only the id field can have the optional @GeneratedValue annotation!");
        }
        return idField;
    }

    public static long timeToMilliSeconds(@NonNull Object time) {
        if (time instanceof Date) {
            return ((Date)time).getTime();
        }
        throw new UnsupportedOperationException("Unsupported time type");
    }

    public static long toPrimitiveLong(@NonNull Object object) {
        if (object instanceof Date) {
            return GremlinUtils.timeToMilliSeconds(object);
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        throw new UnsupportedOperationException("Unsupported object type to long");
    }

    public static <T> GremlinSource<T> toGremlinSource(@NonNull Class<T> domainClass) {
        return new GremlinEntityInformation(domainClass).createGremlinSource();
    }

    public static List<List<String>> toParallelQueryList(@NonNull List<String> queries) {
        ArrayList<List<String>> parallelQueries = new ArrayList<List<String>>();
        ArrayList<String> parallelQuery = new ArrayList<String>();
        for (String query : queries) {
            if (query.equals("barrier")) {
                parallelQueries.add(parallelQuery);
                parallelQuery = new ArrayList();
                continue;
            }
            parallelQuery.add(query);
        }
        parallelQueries.add(parallelQuery);
        return parallelQueries;
    }

    public static Class<?> toEntityClass(@NonNull String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new GremlinUnexpectedSourceTypeException("failed to retrieve class: " + className, e);
        }
    }

    private GremlinUtils() {
    }

    static {
        mapper.configure(MapperFeature.AUTO_DETECT_FIELDS, false);
    }
}

