/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion;

import com.microsoft.spring.data.gremlin.common.GremlinUtils;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.mapping.GremlinPersistentEntity;
import com.microsoft.spring.data.gremlin.mapping.GremlinPersistentProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.EntityConverter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class MappingGremlinConverter
implements EntityConverter<GremlinPersistentEntity<?>, GremlinPersistentProperty, Object, GremlinSource>,
ApplicationContextAware {
    protected final MappingContext<? extends GremlinPersistentEntity<?>, GremlinPersistentProperty> mappingContext;
    protected GenericConversionService conversionService;
    private ApplicationContext applicationContext;

    public MappingGremlinConverter(MappingContext<? extends GremlinPersistentEntity<?>, GremlinPersistentProperty> context) {
        this.mappingContext = context;
        this.conversionService = new GenericConversionService();
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public MappingContext<? extends GremlinPersistentEntity<?>, GremlinPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public <T> T read(Class<T> domainClass, @NonNull GremlinSource source) {
        GremlinSource gremlinSource = source;
        return gremlinSource.doGremlinSourceRead(domainClass, this);
    }

    public void write(@NonNull Object domain, @NonNull GremlinSource source) {
        source.doGremlinSourceWrite(domain, this);
    }

    public ConvertingPropertyAccessor getPropertyAccessor(@NonNull Object domain) {
        GremlinPersistentEntity<?> persistentEntity = this.getPersistentEntity(domain.getClass());
        Assert.notNull(persistentEntity, (String)"persistentEntity should not be null");
        PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(domain);
        return new ConvertingPropertyAccessor(accessor, (ConversionService)this.conversionService);
    }

    public GremlinPersistentEntity<?> getPersistentEntity(@NonNull Class<?> domainClass) {
        return (GremlinPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
    }

    private String getIdFieldName(@NonNull Object domain) {
        return GremlinUtils.getIdField(domain.getClass()).getName();
    }

    private Object getFieldValue(@NonNull Object domain, @NonNull String fieldName) {
        ConvertingPropertyAccessor accessor = this.getPropertyAccessor(domain);
        GremlinPersistentEntity<?> persistentEntity = this.getPersistentEntity(domain.getClass());
        PersistentProperty property = persistentEntity.getPersistentProperty(fieldName);
        return property != null ? accessor.getProperty(property) : null;
    }

    public Object getIdFieldValue(@NonNull Object domain) {
        return this.getFieldValue(domain, this.getIdFieldName(domain));
    }
}

