/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.source;

import com.microsoft.spring.data.gremlin.annotation.EdgeFrom;
import com.microsoft.spring.data.gremlin.annotation.EdgeTo;
import com.microsoft.spring.data.gremlin.common.GremlinUtils;
import com.microsoft.spring.data.gremlin.conversion.MappingGremlinConverter;
import com.microsoft.spring.data.gremlin.conversion.source.AbstractGremlinSourceReader;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceEdge;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceReader;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import com.microsoft.spring.data.gremlin.mapping.GremlinPersistentEntity;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.lang.NonNull;

public class GremlinSourceEdgeReader
extends AbstractGremlinSourceReader
implements GremlinSourceReader {
    @Override
    public <T> T read(@NonNull Class<T> domainClass, @NonNull MappingGremlinConverter converter, @NonNull GremlinSource<T> source) {
        if (!(source instanceof GremlinSourceEdge)) {
            throw new GremlinUnexpectedSourceTypeException("should be instance of GremlinSourceEdge");
        }
        T domain = GremlinUtils.createInstance(domainClass);
        ConvertingPropertyAccessor accessor = converter.getPropertyAccessor(domain);
        GremlinPersistentEntity<?> persistentEntity = converter.getPersistentEntity(domainClass);
        for (Field field : FieldUtils.getAllFields(domainClass)) {
            PersistentProperty property = persistentEntity.getPersistentProperty(field.getName());
            if (property == null) continue;
            if (field.getName().equals("id") || field.getAnnotation(Id.class) != null) {
                accessor.setProperty(property, super.getGremlinSourceId(source));
                continue;
            }
            if (field.getAnnotation(EdgeFrom.class) != null || field.getAnnotation(EdgeTo.class) != null) continue;
            Object value = super.readProperty(property, source.getProperties().get(field.getName()));
            accessor.setProperty(property, value);
        }
        return domain;
    }
}

