/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.query;

import com.microsoft.spring.data.gremlin.annotation.EdgeFrom;
import com.microsoft.spring.data.gremlin.annotation.EdgeTo;
import com.microsoft.spring.data.gremlin.annotation.GeneratedValue;
import com.microsoft.spring.data.gremlin.common.GremlinEntityType;
import com.microsoft.spring.data.gremlin.common.GremlinFactory;
import com.microsoft.spring.data.gremlin.common.GremlinUtils;
import com.microsoft.spring.data.gremlin.conversion.MappingGremlinConverter;
import com.microsoft.spring.data.gremlin.conversion.script.GremlinScriptLiteralEdge;
import com.microsoft.spring.data.gremlin.conversion.script.GremlinScriptLiteralGraph;
import com.microsoft.spring.data.gremlin.conversion.script.GremlinScriptLiteralVertex;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceEdge;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceGraph;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceVertex;
import com.microsoft.spring.data.gremlin.exception.GremlinEntityInformationException;
import com.microsoft.spring.data.gremlin.exception.GremlinInvalidEntityIdFieldException;
import com.microsoft.spring.data.gremlin.exception.GremlinQueryException;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedEntityTypeException;
import com.microsoft.spring.data.gremlin.mapping.GremlinPersistentEntity;
import com.microsoft.spring.data.gremlin.query.GremlinOperations;
import com.microsoft.spring.data.gremlin.query.query.GremlinQuery;
import com.microsoft.spring.data.gremlin.query.query.QueryFindScriptGenerator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class GremlinTemplate
implements GremlinOperations,
ApplicationContextAware {
    private final GremlinFactory factory;
    private final MappingGremlinConverter mappingConverter;
    private Client gremlinClient;
    private ApplicationContext context;

    public GremlinTemplate(@NonNull GremlinFactory factory, @NonNull MappingGremlinConverter converter) {
        this.factory = factory;
        this.mappingConverter = converter;
    }

    @Override
    public MappingGremlinConverter getMappingConverter() {
        return this.mappingConverter;
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public void setApplicationContext(@NonNull ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public Client getGremlinClient() {
        if (this.gremlinClient == null) {
            this.gremlinClient = this.factory.getGremlinClient();
        }
        return this.gremlinClient;
    }

    @NonNull
    private List<Result> executeQuery(@NonNull List<String> queries) {
        List<List<String>> parallelQueries = GremlinUtils.toParallelQueryList(queries);
        return parallelQueries.stream().flatMap(q -> this.executeQueryParallel((List<String>)q).stream()).collect(Collectors.toList());
    }

    @NonNull
    private List<Result> executeQueryParallel(@NonNull List<String> queries) {
        return queries.parallelStream().map(q -> this.getGremlinClient().submit(q).all()).collect(Collectors.toList()).parallelStream().flatMap(f -> {
            try {
                return ((List)f.get()).stream();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new GremlinQueryException("unable to complete query from gremlin", e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public void deleteAll() {
        GremlinScriptLiteralGraph script = new GremlinScriptLiteralGraph();
        List<String> queryList = script.generateDeleteAllScript();
        this.executeQuery(queryList);
    }

    @Override
    public void deleteAll(GremlinEntityType type) {
        GremlinSource source = type.createGremlinSource();
        this.executeQuery(source.getGremlinScriptLiteral().generateDeleteAllScript());
    }

    @Override
    public <T> void deleteAll(GremlinSource<T> source) {
        this.executeQuery(source.getGremlinScriptLiteral().generateDeleteAllByClassScript(source));
    }

    private <T> List<Result> insertInternal(@NonNull T object, @NonNull GremlinSource<T> source) {
        this.mappingConverter.write(object, source);
        return this.executeQuery(source.getGremlinScriptLiteral().generateInsertScript(source));
    }

    @Override
    public <T> T insert(@NonNull T object, GremlinSource<T> source) {
        boolean entityGraph = source instanceof GremlinSourceGraph;
        if (!entityGraph && source.getIdField().isAnnotationPresent(GeneratedValue.class) && source.getId().isPresent()) {
            throw new GremlinInvalidEntityIdFieldException("The entity meant to be created has a non-null id that is marked as @GeneratedValue");
        }
        List<Result> results = this.insertInternal(object, source);
        if (!results.isEmpty()) {
            if (entityGraph) {
                return this.recoverGraphDomain((GremlinSourceGraph)source, results);
            }
            return this.recoverDomain(source, results);
        }
        return null;
    }

    @Override
    public <T> T findVertexById(@NonNull Object id, GremlinSource<T> source) {
        if (source instanceof GremlinSourceVertex) {
            source.setId(id);
            return this.findByIdInternal(source);
        }
        throw new GremlinUnexpectedEntityTypeException("should be vertex domain for findVertexById");
    }

    private Object getEdgeAnnotatedFieldValue(@NonNull Field field, @NonNull Object vertexId) {
        if (field.getType() == String.class || field.getType() == Long.class || field.getType() == Integer.class) {
            return vertexId;
        }
        if (field.getType().isPrimitive()) {
            throw new GremlinUnexpectedEntityTypeException("only String/Long/Integer type of Id Field is allowed");
        }
        return this.findVertexById(vertexId, GremlinUtils.toGremlinSource(field.getType()));
    }

    @NonNull
    private Field getEdgeAnnotatedField(@NonNull Class<?> domainClass, @NonNull Class<? extends Annotation> annotationClass) {
        List fields = FieldUtils.getFieldsListWithAnnotation(domainClass, annotationClass);
        if (fields.size() != 1) {
            throw new GremlinEntityInformationException("should be only one Annotation");
        }
        return (Field)fields.get(0);
    }

    private <T> void completeEdge(@NonNull T domain, @NonNull GremlinSourceEdge source) {
        ConvertingPropertyAccessor accessor = this.mappingConverter.getPropertyAccessor(domain);
        GremlinPersistentEntity<?> persistentEntity = this.mappingConverter.getPersistentEntity(domain.getClass());
        Field fromField = this.getEdgeAnnotatedField(domain.getClass(), EdgeFrom.class);
        Field toField = this.getEdgeAnnotatedField(domain.getClass(), EdgeTo.class);
        PersistentProperty propertyFrom = persistentEntity.getPersistentProperty(fromField.getName());
        PersistentProperty propertyTo = persistentEntity.getPersistentProperty(toField.getName());
        Assert.notNull((Object)propertyFrom, (String)"persistence property should not be null");
        Assert.notNull((Object)propertyTo, (String)"persistence property should not be null");
        accessor.setProperty(propertyFrom, this.getEdgeAnnotatedFieldValue(fromField, source.getVertexIdFrom()));
        accessor.setProperty(propertyTo, this.getEdgeAnnotatedFieldValue(toField, source.getVertexIdTo()));
    }

    @Override
    public <T> T findEdgeById(@NonNull Object id, @NonNull GremlinSource<T> source) {
        if (source instanceof GremlinSourceEdge) {
            return this.findById(id, source);
        }
        throw new GremlinUnexpectedEntityTypeException("should be edge domain for findEdge");
    }

    private <T> T findByIdInternal(@NonNull GremlinSource<T> source) {
        List<String> queryList = source.getGremlinScriptLiteral().generateFindByIdScript(source);
        List<Result> results = this.executeQuery(queryList);
        if (results.isEmpty()) {
            return null;
        }
        return this.recoverDomain(source, results);
    }

    @Override
    public <T> T findById(@NonNull Object id, @NonNull GremlinSource<T> source) {
        if (source instanceof GremlinSourceGraph) {
            throw new UnsupportedOperationException("Gremlin graph cannot be findById.");
        }
        source.setId(id);
        return this.findByIdInternal(source);
    }

    private <T> T updateInternal(@NonNull T object, @NonNull GremlinSource<T> source) {
        this.mappingConverter.write(object, source);
        List<String> queryList = source.getGremlinScriptLiteral().generateUpdateScript(source);
        this.executeQuery(queryList);
        return object;
    }

    @Override
    public <T> T update(@NonNull T object, @NonNull GremlinSource<T> source) {
        Optional<Object> optional = source.getId();
        if (!(source instanceof GremlinSourceGraph || optional.isPresent() && !this.notExistsById(optional.get(), source))) {
            throw new GremlinQueryException("cannot update the object doesn't exist");
        }
        return this.updateInternal(object, source);
    }

    @Override
    public <T> T save(@NonNull T object, @NonNull GremlinSource<T> source) {
        Optional<Object> optional = source.getId();
        boolean entityGraph = source instanceof GremlinSourceGraph;
        if (entityGraph && this.isEmptyGraph(source)) {
            return this.insert(object, source);
        }
        if (!(entityGraph || optional.isPresent() && !this.notExistsById(optional.get(), source))) {
            return this.insert(object, source);
        }
        return this.updateInternal(object, source);
    }

    @Override
    public <T> List<T> findAll(@NonNull GremlinSource<T> source) {
        if (source instanceof GremlinSourceGraph) {
            throw new UnsupportedOperationException("Gremlin graph cannot be findAll.");
        }
        List<String> queryList = source.getGremlinScriptLiteral().generateFindAllScript(source);
        List<Result> results = this.executeQuery(queryList);
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        return this.recoverDomainList(source, results);
    }

    @Override
    public <T> void deleteById(@NonNull Object id, @NonNull GremlinSource<T> source) {
        source.setId(id);
        List<String> queryList = source.getGremlinScriptLiteral().generateDeleteByIdScript(source);
        this.executeQuery(queryList);
    }

    @Override
    public <T> boolean isEmptyGraph(@NonNull GremlinSource<T> source) {
        if (source instanceof GremlinSourceGraph) {
            GremlinScriptLiteralGraph literalGraph = (GremlinScriptLiteralGraph)source.getGremlinScriptLiteral();
            List<String> queryList = literalGraph.generateIsEmptyScript();
            List<Result> results = this.executeQuery(queryList);
            return results.isEmpty();
        }
        throw new GremlinQueryException("only graph domain is allowed.");
    }

    @Override
    public long vertexCount() {
        GremlinScriptLiteralVertex script = new GremlinScriptLiteralVertex();
        List<String> queryList = script.generateCountScript(new GremlinSourceVertex());
        List<Result> results = this.executeQuery(queryList);
        return results.size();
    }

    @Override
    public long edgeCount() {
        GremlinScriptLiteralEdge script = new GremlinScriptLiteralEdge();
        List<String> queryList = script.generateCountScript(new GremlinSourceEdge());
        List<Result> results = this.executeQuery(queryList);
        return results.size();
    }

    private <T> T recoverDomain(@NonNull GremlinSource<T> source, @NonNull List<Result> results) {
        Class<T> domainClass = source.getDomainClass();
        source.doGremlinResultRead(results);
        T domain = this.mappingConverter.read(domainClass, source);
        if (source instanceof GremlinSourceEdge) {
            this.completeEdge(domain, (GremlinSourceEdge)source);
        }
        return domain;
    }

    private <T> List<T> recoverDomainList(@NonNull GremlinSource<T> source, @NonNull List<Result> results) {
        return results.stream().map(r -> this.recoverDomain(source, Collections.singletonList(r))).collect(Collectors.toList());
    }

    private <T> T recoverGraphDomain(@NonNull GremlinSourceGraph<T> source, @NonNull List<Result> results) {
        Class domainClass = source.getDomainClass();
        source.getResultsReader().read(results, source);
        Object domain = source.doGremlinSourceRead(domainClass, this.mappingConverter);
        return domain;
    }

    private <T> boolean notExistsById(@NonNull Object id, @NonNull GremlinSource<T> source) {
        return !this.existsById(id, source);
    }

    @Override
    public <T> boolean existsById(@NonNull Object id, @NonNull GremlinSource<T> source) {
        return this.findById(id, source) != null;
    }

    @Override
    public <T> List<T> find(@NonNull GremlinQuery query, @NonNull GremlinSource<T> source) {
        QueryFindScriptGenerator generator = new QueryFindScriptGenerator(source);
        List<String> queryList = generator.generate(query);
        List<Result> results = this.executeQuery(queryList);
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        return this.recoverDomainList(source, results);
    }
}

