/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.query.criteria;

import com.microsoft.spring.data.gremlin.query.criteria.CriteriaType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class Criteria {
    private String subject;
    private List<Object> subValues;
    private final CriteriaType type;
    private final List<Criteria> subCriteria;

    private Criteria(CriteriaType type) {
        this.type = type;
        this.subCriteria = new ArrayList<Criteria>();
    }

    private static boolean isBinaryOperation(CriteriaType type) {
        switch (type) {
            case AND: 
            case OR: {
                return true;
            }
        }
        return false;
    }

    private static boolean isUnaryOperation(CriteriaType type) {
        switch (type) {
            case EXISTS: 
            case AFTER: 
            case BEFORE: 
            case BETWEEN: 
            case IS_EQUAL: {
                return true;
            }
        }
        return false;
    }

    public static Criteria getUnaryInstance(CriteriaType type, @NonNull String subject, @NonNull List<Object> values) {
        Assert.isTrue((boolean)Criteria.isUnaryOperation(type), (String)"type should be Unary operation");
        Criteria criteria = new Criteria(type);
        criteria.subject = subject;
        criteria.subValues = values;
        return criteria;
    }

    public static Criteria getBinaryInstance(CriteriaType type, @NonNull Criteria left, @NonNull Criteria right) {
        Assert.isTrue((boolean)Criteria.isBinaryOperation(type), (String)"type should be Binary operation");
        Criteria criteria = new Criteria(type);
        criteria.subCriteria.add(left);
        criteria.subCriteria.add(right);
        Assert.isTrue((criteria.getSubCriteria().size() == 2 ? 1 : 0) != 0, (String)"Binary should contain 2 subCriteria");
        return criteria;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<Object> getSubValues() {
        return this.subValues;
    }

    public CriteriaType getType() {
        return this.type;
    }

    public List<Criteria> getSubCriteria() {
        return this.subCriteria;
    }
}

