/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.query.query;

import com.microsoft.spring.data.gremlin.mapping.GremlinPersistentProperty;
import com.microsoft.spring.data.gremlin.query.criteria.Criteria;
import com.microsoft.spring.data.gremlin.query.criteria.CriteriaType;
import com.microsoft.spring.data.gremlin.query.paramerter.GremlinParameterAccessor;
import com.microsoft.spring.data.gremlin.query.query.GremlinQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class GremlinQueryCreator
extends AbstractQueryCreator<GremlinQuery, Criteria> {
    private final MappingContext<?, GremlinPersistentProperty> mappingContext;
    private static final Map<Part.Type, CriteriaType> criteriaMap;

    public GremlinQueryCreator(@NonNull PartTree partTree, @NonNull GremlinParameterAccessor accessor, @NonNull MappingContext<?, GremlinPersistentProperty> mappingContext) {
        super(partTree, (ParameterAccessor)accessor);
        this.mappingContext = mappingContext;
    }

    protected Criteria create(@NonNull Part part, @NonNull Iterator<Object> parameters) {
        Part.Type type = part.getType();
        String subject = this.mappingContext.getPersistentPropertyPath(part.getProperty()).toDotPath();
        ArrayList<Object> values = new ArrayList<Object>();
        if (!criteriaMap.containsKey(type)) {
            throw new UnsupportedOperationException("Unsupported keyword: " + type.toString());
        }
        for (int i = 0; i < part.getNumberOfArguments(); ++i) {
            Assert.isTrue((boolean)parameters.hasNext(), (String)"should not reach the end of iterator");
            values.add(parameters.next());
        }
        return Criteria.getUnaryInstance(criteriaMap.get(type), subject, values);
    }

    protected Criteria and(@NonNull Part part, @NonNull Criteria base, @NonNull Iterator<Object> parameters) {
        Object right = this.create(part, (Iterator)parameters);
        return Criteria.getBinaryInstance(CriteriaType.AND, base, (Criteria)right);
    }

    protected Criteria or(@NonNull Criteria base, @NonNull Criteria criteria) {
        return Criteria.getBinaryInstance(CriteriaType.OR, base, criteria);
    }

    protected GremlinQuery complete(@NonNull Criteria criteria, @NonNull Sort sort) {
        return new GremlinQuery(criteria);
    }

    static {
        HashMap<Part.Type, CriteriaType> map = new HashMap<Part.Type, CriteriaType>();
        map.put(Part.Type.AFTER, CriteriaType.AFTER);
        map.put(Part.Type.BEFORE, CriteriaType.BEFORE);
        map.put(Part.Type.BETWEEN, CriteriaType.BETWEEN);
        map.put(Part.Type.SIMPLE_PROPERTY, CriteriaType.IS_EQUAL);
        map.put(Part.Type.EXISTS, CriteriaType.EXISTS);
        criteriaMap = Collections.unmodifiableMap(map);
    }
}

